/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorUtil {
    private ExecutorUtil() {
    }

    public static boolean uninterruptibleShutdownNow(ExecutorService executor) {
        return ExecutorUtil.shutdownImpl(executor, true, false);
    }

    public static boolean interruptibleShutdown(ExecutorService executor) {
        return ExecutorUtil.shutdownImpl(executor, false, true);
    }

    public static boolean uninterruptibleShutdown(ExecutorService executor) {
        return ExecutorUtil.shutdownImpl(executor, false, false);
    }

    private static boolean shutdownImpl(ExecutorService executor, boolean shutdownNowInitially, boolean shutdownNowOnInterrupt) {
        Preconditions.checkState(!executor.isShutdown());
        if (shutdownNowInitially) {
            executor.shutdownNow();
        } else {
            executor.shutdown();
        }
        boolean interrupted = false;
        while (true) {
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                if (shutdownNowOnInterrupt) {
                    executor.shutdownNow();
                }
                interrupted = true;
                continue;
            }
            break;
        }
        return interrupted;
    }

    public static ThreadPoolExecutor newSlackPool(int threads, String name) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(name + " %d").build(), (r, e) -> r.run());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }
}

