/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.base.Preconditions;

public abstract class ErrorClassifier {
    public static final ErrorClassifier DEFAULT = new ErrorClassifier(){

        @Override
        protected ErrorClassification classifyException(Exception e) {
            return ErrorClassification.NOT_CRITICAL;
        }
    };

    protected abstract ErrorClassification classifyException(Exception var1);

    public final ErrorClassification classify(Throwable e) {
        if (e instanceof Error) {
            return ErrorClassification.AS_CRITICAL_AS_POSSIBLE;
        }
        Preconditions.checkArgument(e instanceof Exception, e);
        return this.classifyException((Exception)e);
    }

    public static enum ErrorClassification {
        NOT_CRITICAL,
        CRITICAL,
        CRITICAL_AND_LOG,
        AS_CRITICAL_AS_POSSIBLE;

    }
}

