/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class BlockingStack<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final BlockingDeque<E> deque = new LinkedBlockingDeque();

    @Override
    public Iterator<E> iterator() {
        return this.deque.iterator();
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.deque.putFirst(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.deque.offerFirst(e, timeout, unit);
    }

    @Override
    public boolean offer(E e) {
        return this.deque.offerFirst(e);
    }

    @Override
    public E take() throws InterruptedException {
        return this.deque.takeFirst();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.deque.pollFirst(timeout, unit);
    }

    @Override
    @Nullable
    public E poll() {
        return this.deque.pollFirst();
    }

    @Override
    public int remainingCapacity() {
        return this.deque.remainingCapacity();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.deque.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        return this.deque.drainTo(c, maxElements);
    }

    @Override
    @Nullable
    public E peek() {
        return this.deque.peekFirst();
    }
}

