/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.devtools.build.lib.concurrent.AbstractQueueVisitor;
import com.google.devtools.build.lib.concurrent.ErrorClassifier;
import com.google.devtools.build.lib.concurrent.ForkJoinQuiescingExecutor;
import com.google.devtools.build.lib.concurrent.NamedForkJoinPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractShardedVisitor<T> {
    protected static final int DEFAULT_THREAD_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_MAX_BATCH_SIZE = 8192;
    public static final ErrorClassifier ERROR_CLASSIFIER = new ErrorClassifier(){

        @Override
        protected ErrorClassifier.ErrorClassification classifyException(Exception e) {
            return e instanceof RuntimeException ? ErrorClassifier.ErrorClassification.CRITICAL_AND_LOG : ErrorClassifier.ErrorClassification.NOT_CRITICAL;
        }
    };
    private final AbstractQueueVisitor executor;
    private final LinkedBlockingQueue<T> remainingItemsToVisit;
    private final int numThreads;

    protected AbstractShardedVisitor(String name) {
        this(ForkJoinQuiescingExecutor.newBuilder().withOwnershipOf(NamedForkJoinPool.newNamedPool(name, DEFAULT_THREAD_COUNT)).setErrorClassifier(ERROR_CLASSIFIER).build(), DEFAULT_THREAD_COUNT);
    }

    public AbstractShardedVisitor(AbstractQueueVisitor executor, int numThreads) {
        this.executor = executor;
        this.numThreads = numThreads;
        this.remainingItemsToVisit = new LinkedBlockingQueue();
    }

    public void scheduleVisitationsAndAwaitQuiescence(Collection<T> itemsToVisit) throws InterruptedException {
        this.remainingItemsToVisit.addAll(itemsToVisit);
        this.shardAndScheduleRemainingItems();
        this.executor.awaitQuiescence(true);
    }

    public void checkComplete() {
        if (this.remainingItemsToVisit.isEmpty()) {
            return;
        }
        int numUnvisitedItems = this.remainingItemsToVisit.size();
        ArrayList unvisitedItems = new ArrayList(10);
        this.remainingItemsToVisit.drainTo(unvisitedItems, 10);
        throw new IllegalStateException(String.format("There are %s item(s) enqueued for visiting but not visited before quiescence (sample: %s)", numUnvisitedItems, Iterables.limit(unvisitedItems, 10)));
    }

    protected int getMaxBatchSize() {
        return 8192;
    }

    private void shardAndScheduleRemainingItems() {
        int numTasksExcludingThis = Ints.checkedCast(this.executor.getTaskCount()) - 1;
        int freeThreads = Math.max(this.numThreads - numTasksExcludingThis, 1);
        int itemsPerThread = this.remainingItemsToVisit.size() / freeThreads + 1;
        int batchSize = Math.min(itemsPerThread, this.getMaxBatchSize());
        for (int i = 0; i < freeThreads; ++i) {
            ArrayList items = new ArrayList(batchSize);
            this.remainingItemsToVisit.drainTo(items, batchSize);
            if (items.isEmpty()) break;
            this.executor.execute(() -> {
                try {
                    this.remainingItemsToVisit.addAll(this.visit(items));
                    this.shardAndScheduleRemainingItems();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    protected abstract Collection<T> visit(Collection<T> var1) throws InterruptedException;
}

