/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.devtools.build.lib.concurrent.BlockingStack;
import com.google.devtools.build.lib.concurrent.ErrorClassifier;
import com.google.devtools.build.lib.concurrent.ForkJoinQuiescingExecutor;
import com.google.devtools.build.lib.concurrent.NamedForkJoinPool;
import com.google.devtools.build.lib.concurrent.QuiescingExecutor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AbstractQueueVisitor
implements QuiescingExecutor {
    private volatile Throwable unhandled = null;
    private volatile Throwable catastrophe;
    private final Object zeroRemainingTasks = new Object();
    private final AtomicLong remainingTasks = new AtomicLong(0L);
    private final ReadWriteLock outstandingFuturesLock = new ReentrantReadWriteLock();
    private final Set<ListenableFuture<?>> outstandingFutures = Sets.newConcurrentHashSet();
    private volatile boolean jobsMustBeStopped = false;
    private final Map<Thread, AtomicLong> jobs = new ConcurrentHashMap<Thread, AtomicLong>();
    private final ExecutorService executorService;
    private volatile boolean threadInterrupted;
    private final CountDownLatch interruptedLatch = new CountDownLatch(1);
    private final CountDownLatch exceptionLatch = new CountDownLatch(1);
    private final ExceptionHandlingMode exceptionHandlingMode;
    private final ExecutorOwnership executorOwnership;
    private final ErrorClassifier errorClassifier;
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    private static ExecutorService createExecutorService(int parallelism, long keepAliveTime, TimeUnit units, BlockingQueue<Runnable> workQueue, String poolName) {
        return new ThreadPoolExecutor(parallelism, parallelism, keepAliveTime, units, workQueue, new ThreadFactoryBuilder().setNameFormat(Preconditions.checkNotNull(poolName) + " %d").build());
    }

    public static ExecutorService createExecutorService(int parallelism, String poolName) {
        return NamedForkJoinPool.newNamedPool(poolName, parallelism);
    }

    public static AbstractQueueVisitor createWithExecutorService(ExecutorService executorService, ExceptionHandlingMode exceptionHandlingMode, ErrorClassifier errorClassifier) {
        if (executorService instanceof ForkJoinPool) {
            return ForkJoinQuiescingExecutor.newBuilder().withOwnershipOf((ForkJoinPool)executorService).setErrorClassifier(errorClassifier).build();
        }
        return new AbstractQueueVisitor(executorService, ExecutorOwnership.PRIVATE, exceptionHandlingMode, errorClassifier);
    }

    public static AbstractQueueVisitor create(String name, int parallelism, ErrorClassifier errorClassifier) {
        return AbstractQueueVisitor.createWithExecutorService(NamedForkJoinPool.newNamedPool(name, parallelism), ExceptionHandlingMode.KEEP_GOING, errorClassifier);
    }

    public AbstractQueueVisitor(int parallelism, long keepAliveTime, TimeUnit units, ExceptionHandlingMode exceptionHandlingMode, String poolName, ErrorClassifier errorClassifier) {
        this(AbstractQueueVisitor.createExecutorService(parallelism, keepAliveTime, units, new BlockingStack<Runnable>(), poolName), ExecutorOwnership.PRIVATE, exceptionHandlingMode, errorClassifier);
    }

    protected AbstractQueueVisitor(ExecutorService executorService, ExecutorOwnership executorOwnership, ExceptionHandlingMode exceptionHandlingMode, ErrorClassifier errorClassifier) {
        this.exceptionHandlingMode = exceptionHandlingMode;
        this.executorOwnership = executorOwnership;
        this.executorService = Preconditions.checkNotNull(executorService);
        this.errorClassifier = Preconditions.checkNotNull(errorClassifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitQuiescence(boolean interruptWorkers) throws InterruptedException {
        Throwables.propagateIfPossible(this.catastrophe);
        try {
            Object object = this.zeroRemainingTasks;
            synchronized (object) {
                while (this.remainingTasks.get() != 0L && !this.jobsMustBeStopped) {
                    this.zeroRemainingTasks.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.setInterrupted();
        }
        this.awaitTermination(interruptWorkers);
    }

    @Override
    public final void execute(Runnable runnable) {
        this.executeWithExecutorService(runnable, this.executorService);
    }

    protected void executeWithExecutorService(Runnable runnable, ExecutorService executorService) {
        block2: {
            WrappedRunnable wrappedRunnable = new WrappedRunnable(runnable);
            try {
                long tasks = this.remainingTasks.incrementAndGet();
                Preconditions.checkState(tasks > 0L, "Incrementing remaining tasks counter resulted in impossible non-positive number.");
                this.executeWrappedRunnable(wrappedRunnable, executorService);
            }
            catch (Throwable e) {
                if (wrappedRunnable.ran) break block2;
                this.recordError(e);
            }
        }
    }

    protected void executeWrappedRunnable(WrappedRunnable runnable, ExecutorService executorService) {
        executorService.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void maybeSaveUnhandledThrowable(Throwable e, boolean markToStopJobs) {
        boolean critical = false;
        ErrorClassifier.ErrorClassification errorClassification = this.errorClassifier.classify(e);
        switch (errorClassification) {
            case AS_CRITICAL_AS_POSSIBLE: 
            case CRITICAL_AND_LOG: {
                critical = true;
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Found critical error in queue visitor");
                break;
            }
            case CRITICAL: {
                critical = true;
                break;
            }
        }
        if (this.unhandled == null || errorClassification.compareTo(this.errorClassifier.classify(this.unhandled)) > 0) {
            this.unhandled = e;
            this.exceptionLatch.countDown();
        }
        if (markToStopJobs) {
            Object object = this.zeroRemainingTasks;
            synchronized (object) {
                if (critical && !this.jobsMustBeStopped) {
                    this.jobsMustBeStopped = true;
                    this.zeroRemainingTasks.notify();
                }
            }
        }
    }

    private void recordError(Throwable e) {
        try {
            if (e instanceof RejectedExecutionException && this.threadInterrupted) {
                return;
            }
            this.catastrophe = e;
            this.maybeSaveUnhandledThrowable(e, false);
        }
        finally {
            this.decrementRemainingTasks();
        }
    }

    private void addJob(Thread thread) {
        this.jobs.computeIfAbsent(thread, k -> new AtomicLong()).incrementAndGet();
    }

    private void removeJob(Thread thread) {
        if (this.jobs.get(thread).decrementAndGet() == 0L) {
            this.jobs.remove(thread);
        }
    }

    protected final void setInterrupted() {
        this.threadInterrupted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementRemainingTasks() {
        long tasks = this.remainingTasks.decrementAndGet();
        Preconditions.checkState(tasks >= 0L, "Decrementing remaining tasks counter resulted in impossible negative number.");
        if (tasks == 0L) {
            Object object = this.zeroRemainingTasks;
            synchronized (object) {
                this.zeroRemainingTasks.notify();
            }
        }
    }

    protected boolean blockNewActions() {
        return this.isInterrupted() || this.unhandled != null && this.exceptionHandlingMode == ExceptionHandlingMode.FAIL_FAST;
    }

    @Override
    @VisibleForTesting
    public final CountDownLatch getExceptionLatchForTestingOnly() {
        return this.exceptionLatch;
    }

    @Override
    @VisibleForTesting
    public final CountDownLatch getInterruptionLatchForTestingOnly() {
        return this.interruptedLatch;
    }

    protected final boolean isInterrupted() {
        return this.threadInterrupted;
    }

    public final long getTaskCount() {
        return this.remainingTasks.get();
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void dependOnFuture(ListenableFuture<?> future) throws InterruptedException {
        this.outstandingFuturesLock.readLock().lock();
        try {
            if (this.threadInterrupted) {
                future.cancel(true);
                throw new InterruptedException();
            }
            this.remainingTasks.incrementAndGet();
            this.outstandingFutures.add(future);
            future.addListener(() -> this.markFutureDone(future), MoreExecutors.directExecutor());
        }
        finally {
            this.outstandingFuturesLock.readLock().unlock();
        }
    }

    private void markFutureDone(ListenableFuture<?> future) {
        this.decrementRemainingTasks();
        this.outstandingFuturesLock.readLock().lock();
        try {
            if (this.threadInterrupted) {
                return;
            }
            this.outstandingFutures.remove(future);
        }
        finally {
            this.outstandingFuturesLock.readLock().unlock();
        }
    }

    protected final boolean mustJobsBeStopped() {
        return this.jobsMustBeStopped;
    }

    protected final void awaitTermination(boolean interruptWorkers) throws InterruptedException {
        this.reallyAwaitTermination(interruptWorkers);
        if (this.isInterrupted()) {
            Thread.currentThread().interrupt();
        }
        Throwables.propagateIfPossible(this.unhandled);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyAwaitTermination(boolean interruptWorkers) {
        if (interruptWorkers && !this.jobs.isEmpty()) {
            this.interruptInFlightTasks();
        }
        if (interruptWorkers) {
            this.cancelAllFutures();
        }
        if (this.isInterrupted()) {
            this.interruptedLatch.countDown();
        }
        Throwables.propagateIfPossible(this.catastrophe);
        Object object = this.zeroRemainingTasks;
        synchronized (object) {
            while (this.remainingTasks.get() != 0L) {
                try {
                    this.zeroRemainingTasks.wait();
                }
                catch (InterruptedException e) {
                    this.setInterrupted();
                }
            }
        }
        if (this.executorOwnership == ExecutorOwnership.PRIVATE) {
            this.shutdownExecutorService(this.catastrophe);
        }
    }

    protected void shutdownExecutorService(Throwable catastrophe) {
        this.executorService.shutdown();
        while (true) {
            try {
                Throwables.propagateIfPossible(catastrophe);
                this.executorService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.setInterrupted();
                continue;
            }
            break;
        }
    }

    private void interruptInFlightTasks() {
        Thread thisThread = Thread.currentThread();
        for (Thread thread : this.jobs.keySet()) {
            if (thisThread == thread) continue;
            thread.interrupt();
        }
    }

    private void cancelAllFutures() {
        this.outstandingFuturesLock.writeLock().lock();
        try {
            for (ListenableFuture<?> future : this.outstandingFutures) {
                future.cancel(true);
            }
            this.outstandingFutures.clear();
        }
        finally {
            this.outstandingFuturesLock.writeLock().unlock();
        }
    }

    protected final class WrappedRunnable
    implements Runnable,
    Comparable<WrappedRunnable> {
        private final Runnable originalRunnable;
        private volatile boolean ran;

        private WrappedRunnable(Runnable originalRunnable) {
            this.originalRunnable = originalRunnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.ran = true;
            Thread thread = null;
            boolean addedJob = false;
            try {
                thread = Thread.currentThread();
                AbstractQueueVisitor.this.addJob(thread);
                addedJob = true;
                if (AbstractQueueVisitor.this.blockNewActions()) {
                    return;
                }
                this.originalRunnable.run();
            }
            catch (Throwable e) {
                AbstractQueueVisitor.this.maybeSaveUnhandledThrowable(e, true);
            }
            finally {
                try {
                    if (thread != null && addedJob) {
                        AbstractQueueVisitor.this.removeJob(thread);
                    }
                }
                finally {
                    AbstractQueueVisitor.this.decrementRemainingTasks();
                }
            }
        }

        @Override
        public int compareTo(WrappedRunnable o) {
            return ((Comparable)((Object)this.originalRunnable)).compareTo(o.originalRunnable);
        }
    }

    public static enum ExceptionHandlingMode {
        FAIL_FAST,
        KEEP_GOING;

    }

    protected static enum ExecutorOwnership {
        PRIVATE,
        SHARED;

    }
}

