/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import java.util.HashMap;

public enum Order {
    STABLE_ORDER("default"),
    COMPILE_ORDER("postorder"),
    LINK_ORDER("topological"),
    NAIVE_LINK_ORDER("preorder");

    private static final ImmutableMap<String, Order> VALUES;
    private static final Order[] ORDINALS;
    private final String starlarkName;
    private final NestedSet<?> emptySet;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final Order STABLE_ORDER_CONSTANT;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final Order COMPILE_ORDER_CONSTANT;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final Order LINK_ORDER_CONSTANT;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final Order NAIVE_LINK_ORDER_CONSTANT;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final NestedSet<?> EMPTY_STABLE;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final NestedSet<?> EMPTY_COMPILE;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final NestedSet<?> EMPTY_LINK;
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final NestedSet<?> EMPTY_NAIVE_LINK;

    private Order(String starlarkName) {
        this.starlarkName = starlarkName;
        this.emptySet = new NestedSet(this);
    }

    <E> NestedSet<E> emptySet() {
        return this.emptySet;
    }

    public String getStarlarkName() {
        return this.starlarkName;
    }

    public static Order parse(String name) {
        if (VALUES.containsKey(name)) {
            return VALUES.get(name);
        }
        throw new IllegalArgumentException("Invalid order: " + name);
    }

    public boolean isCompatible(Order other) {
        return this == other || this == STABLE_ORDER || other == STABLE_ORDER;
    }

    static Order getOrder(int ordinal) {
        return ORDINALS[ordinal];
    }

    static {
        STABLE_ORDER_CONSTANT = STABLE_ORDER;
        COMPILE_ORDER_CONSTANT = COMPILE_ORDER;
        LINK_ORDER_CONSTANT = LINK_ORDER;
        NAIVE_LINK_ORDER_CONSTANT = NAIVE_LINK_ORDER;
        EMPTY_STABLE = STABLE_ORDER.emptySet();
        EMPTY_COMPILE = COMPILE_ORDER.emptySet();
        EMPTY_LINK = LINK_ORDER.emptySet();
        EMPTY_NAIVE_LINK = NAIVE_LINK_ORDER.emptySet();
        ORDINALS = Order.values();
        HashMap<String, Order> entries = Maps.newHashMapWithExpectedSize(ORDINALS.length);
        for (Order current : ORDINALS) {
            entries.put(current.getStarlarkName(), current);
        }
        VALUES = ImmutableMap.copyOf(entries);
    }
}

