/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import java.util.Collection;

public final class NestedSetVisitor<E> {
    private final Receiver<E> callback;
    private final VisitedState visited;

    public NestedSetVisitor(Receiver<E> callback, VisitedState visited) {
        this.callback = Preconditions.checkNotNull(callback);
        this.visited = Preconditions.checkNotNull(visited);
    }

    public void visit(NestedSet<E> nestedSet) throws InterruptedException {
        if (!nestedSet.isEmpty()) {
            this.visitRaw(nestedSet.getChildrenInterruptibly());
        }
    }

    public void visit(Collection<E> collection) {
        for (E e : collection) {
            if (!this.visited.add(e)) continue;
            this.callback.accept(e);
        }
    }

    private void visitRaw(Object node) {
        if (this.visited.add(node)) {
            if (node instanceof Object[]) {
                for (Object child : (Object[])node) {
                    this.visitRaw(child);
                }
            } else {
                this.callback.accept(node);
            }
        }
    }

    public static interface VisitedState {
        public boolean add(Object var1);
    }

    public static interface Receiver<E> {
        public void accept(E var1);
    }
}

