/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.devtools.build.lib.bugreport.BugReporter;
import com.google.devtools.build.lib.collect.nestedset.AutoValue_NestedSetStore_FingerprintComputationResult;
import com.google.devtools.build.lib.collect.nestedset.NestedSetSerializationCache;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationDependencyProvider;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;

public class NestedSetStore {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Duration FETCH_FROM_STORAGE_LOGGING_THRESHOLD = Duration.ofSeconds(5L);
    public static final Function<SerializationDependencyProvider, ?> NO_CONTEXT = ctx -> "";
    private final NestedSetStorageEndpoint endpoint;
    private final Executor executor;
    private final NestedSetSerializationCache nestedSetCache;
    private final Function<SerializationDependencyProvider, ?> cacheContextFn;

    public NestedSetStore(NestedSetStorageEndpoint endpoint, Executor executor, BugReporter bugReporter, Function<SerializationDependencyProvider, ?> cacheContextFn) {
        this(endpoint, executor, new NestedSetSerializationCache(bugReporter), cacheContextFn);
    }

    @VisibleForTesting
    NestedSetStore(NestedSetStorageEndpoint endpoint, Executor executor, NestedSetSerializationCache nestedSetCache, Function<SerializationDependencyProvider, ?> cacheContextFn) {
        this.endpoint = Preconditions.checkNotNull(endpoint);
        this.executor = Preconditions.checkNotNull(executor);
        this.nestedSetCache = Preconditions.checkNotNull(nestedSetCache);
        this.cacheContextFn = Preconditions.checkNotNull(cacheContextFn);
    }

    public static NestedSetStore inMemory() {
        return new NestedSetStore((NestedSetStorageEndpoint)new InMemoryNestedSetStorageEndpoint(), MoreExecutors.directExecutor(), BugReporter.defaultInstance(), NO_CONTEXT);
    }

    FingerprintComputationResult computeFingerprintAndStore(Object[] contents, SerializationContext serializationContext) throws SerializationException, IOException {
        return this.computeFingerprintAndStore(contents, serializationContext, this.cacheContextFn.apply(serializationContext));
    }

    private FingerprintComputationResult computeFingerprintAndStore(Object[] contents, SerializationContext serializationContext, Object cacheContext) throws SerializationException, IOException {
        ListenableFuture<Void> writeFuture;
        FingerprintComputationResult result;
        FingerprintComputationResult existingResult;
        FingerprintComputationResult priorFingerprint = this.nestedSetCache.fingerprintForContents(contents);
        if (priorFingerprint != null) {
            return priorFingerprint;
        }
        SerializationContext newSerializationContext = serializationContext.getNewMemoizingContext();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(byteArrayOutputStream);
        ImmutableList.Builder futureBuilder = ImmutableList.builder();
        try {
            codedOutputStream.writeInt32NoTag(contents.length);
            for (Object child : contents) {
                if (child instanceof Object[]) {
                    FingerprintComputationResult fingerprintComputationResult = this.computeFingerprintAndStore((Object[])child, serializationContext, cacheContext);
                    futureBuilder.add(fingerprintComputationResult.writeStatus());
                    newSerializationContext.serialize(fingerprintComputationResult.fingerprint(), codedOutputStream);
                    continue;
                }
                newSerializationContext.serialize(child, codedOutputStream);
            }
            codedOutputStream.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not serialize NestedSet contents", e);
        }
        byte[] serializedBytes = byteArrayOutputStream.toByteArray();
        ByteString fingerprint = ByteString.copyFrom(Hashing.md5().hashBytes(serializedBytes).asBytes());
        SettableFuture<Void> localWriteFuture = SettableFuture.create();
        futureBuilder.add(localWriteFuture);
        ListenableFuture<Void> innerWriteFutures = newSerializationContext.createFutureToBlockWritingOn();
        if (innerWriteFutures != null) {
            futureBuilder.add(innerWriteFutures);
        }
        if ((existingResult = this.nestedSetCache.putIfAbsent(contents, result = FingerprintComputationResult.create(fingerprint, writeFuture = Futures.whenAllSucceed(futureBuilder.build()).call(() -> null, MoreExecutors.directExecutor())), cacheContext)) != null) {
            return existingResult;
        }
        localWriteFuture.setFuture(this.endpoint.put(fingerprint, serializedBytes));
        return result;
    }

    private static ListenableFuture<Object[]> maybeWrapInFuture(Object contents) {
        if (contents instanceof Object[]) {
            return Futures.immediateFuture((Object[])contents);
        }
        return (ListenableFuture)contents;
    }

    Object getContentsAndDeserialize(ByteString fingerprint, DeserializationContext deserializationContext) throws IOException {
        return this.getContentsAndDeserialize(fingerprint, deserializationContext, this.cacheContextFn.apply(deserializationContext));
    }

    private Object getContentsAndDeserialize(ByteString fingerprint, DeserializationContext deserializationContext, Object cacheContext) throws IOException {
        SettableFuture<Object[]> future = SettableFuture.create();
        Object contents = this.nestedSetCache.putFutureIfAbsent(fingerprint, future, cacheContext);
        if (contents != null) {
            return contents;
        }
        ListenableFuture<byte[]> retrieved = this.endpoint.get(fingerprint);
        Stopwatch fetchStopwatch = Stopwatch.createStarted();
        future.setFuture(Futures.transformAsync(retrieved, bytes -> {
            Duration fetchDuration = fetchStopwatch.elapsed();
            if (FETCH_FROM_STORAGE_LOGGING_THRESHOLD.compareTo(fetchDuration) < 0) {
                ((GoogleLogger.Api)logger.atInfo()).log("NestedSet fetch took: %dms, size: %dB", fetchDuration.toMillis(), ((byte[])bytes).length);
            }
            CodedInputStream codedIn = CodedInputStream.newInstance(bytes);
            int numberOfElements = codedIn.readInt32();
            DeserializationContext newDeserializationContext = deserializationContext.getNewMemoizingContext();
            ImmutableList.Builder deserializationFutures = ImmutableList.builderWithExpectedSize(numberOfElements);
            for (int i = 0; i < numberOfElements; ++i) {
                Object deserializedElement = newDeserializationContext.deserialize(codedIn);
                if (deserializedElement instanceof ByteString) {
                    Object innerContents = this.getContentsAndDeserialize((ByteString)deserializedElement, deserializationContext, cacheContext);
                    deserializationFutures.add(NestedSetStore.maybeWrapInFuture(innerContents));
                    continue;
                }
                deserializationFutures.add(Futures.immediateFuture(deserializedElement));
            }
            return Futures.transform(Futures.allAsList(deserializationFutures.build()), List::toArray, this.executor);
        }, this.executor));
        return future;
    }

    @AutoValue
    static abstract class FingerprintComputationResult {
        FingerprintComputationResult() {
        }

        static FingerprintComputationResult create(ByteString fingerprint, ListenableFuture<Void> writeStatus) {
            return new AutoValue_NestedSetStore_FingerprintComputationResult(fingerprint, writeStatus);
        }

        abstract ByteString fingerprint();

        abstract ListenableFuture<Void> writeStatus();
    }

    @VisibleForTesting
    public static class InMemoryNestedSetStorageEndpoint
    implements NestedSetStorageEndpoint {
        private final ConcurrentHashMap<ByteString, byte[]> fingerprintToContents = new ConcurrentHashMap();

        @Override
        public ListenableFuture<Void> put(ByteString fingerprint, byte[] serializedBytes) {
            this.fingerprintToContents.put(fingerprint, serializedBytes);
            return Futures.immediateFuture(null);
        }

        @Override
        public ListenableFuture<byte[]> get(ByteString fingerprint) {
            return Futures.immediateFuture(this.fingerprintToContents.get(fingerprint));
        }
    }

    public static interface NestedSetStorageEndpoint {
        public ListenableFuture<Void> put(ByteString var1, byte[] var2) throws IOException;

        public ListenableFuture<byte[]> get(ByteString var1) throws IOException;
    }

    public static final class MissingNestedSetException
    extends Exception {
        public MissingNestedSetException(ByteString fingerprint) {
            this(fingerprint, null);
        }

        public MissingNestedSetException(ByteString fingerprint, @Nullable Throwable cause) {
            super("No NestedSet data for " + fingerprint, cause);
        }
    }
}

