/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.devtools.build.lib.bugreport.BugReporter;
import com.google.devtools.build.lib.collect.nestedset.AutoValue_NestedSetSerializationCache_FingerprintKey;
import com.google.devtools.build.lib.collect.nestedset.NestedSetStore;
import com.google.devtools.build.lib.skyframe.serialization.SerializationConstants;
import com.google.protobuf.ByteString;
import javax.annotation.Nullable;

class NestedSetSerializationCache {
    private final Cache<FingerprintKey, Object> fingerprintToContents = Caffeine.newBuilder().initialCapacity(SerializationConstants.DESERIALIZATION_POOL_SIZE).weakValues().build();
    private final Cache<Object[], NestedSetStore.FingerprintComputationResult> contentsToFingerprint = Caffeine.newBuilder().initialCapacity(SerializationConstants.DESERIALIZATION_POOL_SIZE).weakKeys().build();
    private final BugReporter bugReporter;

    NestedSetSerializationCache(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Nullable
    Object putFutureIfAbsent(ByteString fingerprint, SettableFuture<Object[]> future, Object context) {
        Preconditions.checkArgument(!future.isDone(), "Must pass a fresh future: %s", future);
        SettableFuture<Object[]> existing = this.fingerprintToContents.asMap().putIfAbsent(FingerprintKey.of(fingerprint, context), future);
        if (existing != null) {
            return existing;
        }
        this.unwrapWhenDone(fingerprint, future, context);
        return null;
    }

    private void unwrapWhenDone(final ByteString fingerprint, ListenableFuture<Object[]> futureContents, final Object context) {
        Futures.addCallback(futureContents, new FutureCallback<Object[]>(){

            @Override
            public void onSuccess(Object[] contents) {
                NestedSetSerializationCache.this.putIfAbsent(contents, NestedSetStore.FingerprintComputationResult.create(fingerprint, Futures.immediateVoidFuture()), context);
            }

            @Override
            public void onFailure(Throwable t2) {
                NestedSetSerializationCache.this.bugReporter.sendNonFatalBugReport(t2);
            }
        }, MoreExecutors.directExecutor());
    }

    @Nullable
    NestedSetStore.FingerprintComputationResult fingerprintForContents(Object[] contents) {
        return this.contentsToFingerprint.getIfPresent(contents);
    }

    @Nullable
    NestedSetStore.FingerprintComputationResult putIfAbsent(Object[] contents, NestedSetStore.FingerprintComputationResult result, Object context) {
        NestedSetStore.FingerprintComputationResult existingResult = this.contentsToFingerprint.asMap().putIfAbsent(contents, result);
        if (existingResult != null) {
            return existingResult;
        }
        this.fingerprintToContents.put(FingerprintKey.of(result.fingerprint(), context), contents);
        return null;
    }

    @AutoValue
    static abstract class FingerprintKey {
        FingerprintKey() {
        }

        abstract ByteString fingerprint();

        abstract Object context();

        static FingerprintKey of(ByteString fingerprint, Object context) {
            return new AutoValue_NestedSetSerializationCache_FingerprintKey(fingerprint, context);
        }
    }
}

