/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.collect.nestedset.NestedSetBuilder;
import com.google.devtools.build.lib.collect.nestedset.NestedSetStore;
import com.google.devtools.build.lib.collect.nestedset.Order;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class NestedSetCodecWithStore
implements ObjectCodec<NestedSet<?>> {
    private final NestedSetStore nestedSetStore;
    private final Cache<EqualsWrapper, NestedSet<?>> interner = Caffeine.newBuilder().weakValues().build();

    public NestedSetCodecWithStore(NestedSetStore nestedSetStore) {
        this.nestedSetStore = nestedSetStore;
    }

    @Override
    public Class<NestedSet<?>> getEncodedClass() {
        return NestedSet.class;
    }

    @Override
    public void serialize(SerializationContext context, NestedSet<?> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        context.serialize((Object)obj.getOrder(), codedOut);
        if (obj.isEmpty()) {
            codedOut.writeEnumNoTag(NestedSetSize.EMPTY.ordinal());
        } else if (obj.isSingleton()) {
            codedOut.writeEnumNoTag(NestedSetSize.LEAF.ordinal());
            context.serialize(obj.getChildren(), codedOut);
        } else {
            codedOut.writeEnumNoTag(NestedSetSize.NONLEAF.ordinal());
            codedOut.writeInt32NoTag(obj.getApproxDepth());
            NestedSetStore.FingerprintComputationResult fingerprintComputationResult = this.nestedSetStore.computeFingerprintAndStore((Object[])obj.getChildren(), context);
            context.addFutureToBlockWritingOn(fingerprintComputationResult.writeStatus());
            codedOut.writeByteArrayNoTag(fingerprintComputationResult.fingerprint().toByteArray());
        }
        this.interner.put(new EqualsWrapper(obj), obj);
    }

    @Override
    public NestedSet<?> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Order order = (Order)((Object)context.deserialize(codedIn));
        NestedSetSize nestedSetSize = NestedSetSize.values()[codedIn.readEnum()];
        switch (nestedSetSize) {
            case EMPTY: {
                return NestedSetBuilder.emptySet(order);
            }
            case LEAF: {
                Object contents = context.deserialize(codedIn);
                return this.intern(order, 1, contents);
            }
            case NONLEAF: {
                int depth = codedIn.readInt32();
                ByteString fingerprint = ByteString.copyFrom(codedIn.readByteArray());
                return this.intern(order, depth, this.nestedSetStore.getContentsAndDeserialize(fingerprint, context));
            }
        }
        throw new IllegalStateException("NestedSet size " + nestedSetSize + " not known");
    }

    private NestedSet<?> intern(Order order, int depth, Object contents) {
        NestedSet result = contents instanceof ListenableFuture ? NestedSet.withFuture(order, depth, (ListenableFuture)contents) : NestedSet.forDeserialization(order, depth, contents);
        return this.interner.get(new EqualsWrapper(result), unused -> result);
    }

    private static final class EqualsWrapper {
        private final Order order;
        private final Object children;

        private EqualsWrapper(NestedSet<?> nestedSet) {
            this.order = nestedSet.getOrder();
            this.children = nestedSet.children;
        }

        public int hashCode() {
            int childrenHashCode;
            if (this.children instanceof ListenableFuture && ((ListenableFuture)this.children).isDone()) {
                try {
                    childrenHashCode = Futures.getDone((ListenableFuture)this.children).hashCode();
                }
                catch (ExecutionException e) {
                    childrenHashCode = this.children.hashCode();
                }
            } else {
                childrenHashCode = this.children.hashCode();
            }
            return 37 * this.order.hashCode() + childrenHashCode;
        }

        private static boolean deserializingAndMaterializedSetsAreEqual(Object[] contents, ListenableFuture<Object[]> contentsFuture) {
            if (!contentsFuture.isDone()) {
                return false;
            }
            try {
                return Futures.getDone(contentsFuture) == contents;
            }
            catch (ExecutionException e) {
                return false;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EqualsWrapper)) {
                return false;
            }
            EqualsWrapper that = (EqualsWrapper)obj;
            if (this.order.equals((Object)that.order) && this.children.equals(that.children)) {
                return true;
            }
            if (this.children instanceof ListenableFuture && that.children instanceof Object[]) {
                return EqualsWrapper.deserializingAndMaterializedSetsAreEqual((Object[])that.children, (ListenableFuture)this.children);
            }
            if (that.children instanceof ListenableFuture && this.children instanceof Object[]) {
                return EqualsWrapper.deserializingAndMaterializedSetsAreEqual((Object[])this.children, (ListenableFuture)that.children);
            }
            return false;
        }
    }

    private static enum NestedSetSize {
        EMPTY,
        LEAF,
        NONLEAF;

    }
}

