/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.collect.compacthashset.CompactHashSet;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.collect.nestedset.Order;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Set;

public final class NestedSetBuilder<E> {
    private final Order order;
    private CompactHashSet<E> items;
    private CompactHashSet<NestedSet<E>> transitiveSets;
    private static final LoadingCache<ImmutableList<?>, NestedSet<?>> stableOrderImmutableListCache = Caffeine.newBuilder().initialCapacity(16).weakKeys().build(list -> new NestedSetBuilder(Order.STABLE_ORDER).addAll((Iterable)list).build());

    public NestedSetBuilder(Order order) {
        this.order = order;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isEmpty() {
        return this.items == null && this.transitiveSets == null;
    }

    @CanIgnoreReturnValue
    public NestedSetBuilder<E> add(E element) {
        Preconditions.checkNotNull(element);
        if (this.items == null) {
            this.items = CompactHashSet.create();
        }
        this.items.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public NestedSetBuilder<E> addAll(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        if (this.items == null) {
            int n = Iterables.size(elements);
            if (n == 0) {
                return this;
            }
            this.items = CompactHashSet.createWithExpectedSize(n);
        }
        Iterables.addAll(this.items, elements);
        return this;
    }

    @CanIgnoreReturnValue
    public NestedSetBuilder<E> addTransitive(NestedSet<? extends E> subset) {
        Preconditions.checkNotNull(subset);
        Preconditions.checkArgument(this.order.isCompatible(subset.getOrder()), "Order mismatch: %s != %s", (Object)subset.getOrder().getStarlarkName(), (Object)this.order.getStarlarkName());
        if (!subset.isEmpty()) {
            if (this.transitiveSets == null) {
                this.transitiveSets = CompactHashSet.create();
            }
            this.transitiveSets.add(subset);
        }
        return this;
    }

    public NestedSet<E> build() {
        try {
            return this.buildInternal(NestedSet.InterruptStrategy.CRASH);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot throw with InterruptStrategy.CRASH", e);
        }
    }

    public NestedSet<E> buildInterruptibly() throws InterruptedException {
        return this.buildInternal(NestedSet.InterruptStrategy.PROPAGATE);
    }

    private NestedSet<E> buildInternal(NestedSet.InterruptStrategy interruptStrategy) throws InterruptedException {
        NestedSet<E> candidate;
        if (this.isEmpty()) {
            return this.order.emptySet();
        }
        Set direct = MoreObjects.firstNonNull(this.items, ImmutableSet.of());
        Set transitive = MoreObjects.firstNonNull(this.transitiveSets, ImmutableSet.of());
        if (transitive.size() == 1 && direct.size() <= 1 && (candidate = Iterables.getOnlyElement(this.transitiveSets)).getOrder() == this.order && (direct.isEmpty() || Iterables.getOnlyElement(direct).equals(candidate.getChildrenInterruptibly()))) {
            return candidate;
        }
        return new NestedSet(this.order, direct, transitive, interruptStrategy);
    }

    public static <E> NestedSet<E> wrap(Order order, Iterable<? extends E> wrappedItems) {
        ImmutableList wrappedList;
        if (Iterables.isEmpty(wrappedItems)) {
            return order.emptySet();
        }
        if (order == Order.STABLE_ORDER && wrappedItems instanceof ImmutableList && (wrappedList = (ImmutableList)wrappedItems).size() > 1) {
            return stableOrderImmutableListCache.get(wrappedList);
        }
        return new NestedSetBuilder<E>(order).addAll(wrappedItems).build();
    }

    public static <E> NestedSet<E> create(Order order, E ... elems) {
        return NestedSetBuilder.wrap(order, ImmutableList.copyOf(elems));
    }

    public static <E> NestedSet<E> emptySet(Order order) {
        return order.emptySet();
    }

    public static <E> NestedSetBuilder<E> stableOrder() {
        return new NestedSetBuilder<E>(Order.STABLE_ORDER);
    }

    public static <E> NestedSetBuilder<E> compileOrder() {
        return new NestedSetBuilder<E>(Order.COMPILE_ORDER);
    }

    public static <E> NestedSetBuilder<E> linkOrder() {
        return new NestedSetBuilder<E>(Order.LINK_ORDER);
    }

    public static <E> NestedSetBuilder<E> naiveLinkOrder() {
        return new NestedSetBuilder<E>(Order.NAIVE_LINK_ORDER);
    }

    public static <E> NestedSetBuilder<E> fromNestedSet(NestedSet<? extends E> set) {
        return new NestedSetBuilder<E>(set.getOrder()).addTransitive(set);
    }

    public static <E> NestedSetBuilder<E> fromNestedSets(Iterable<NestedSet<E>> sets) {
        NestedSet firstSet = Iterables.getFirst(sets, null);
        if (firstSet == null) {
            return NestedSetBuilder.stableOrder();
        }
        NestedSetBuilder<E> result = new NestedSetBuilder<E>(firstSet.getOrder());
        sets.forEach(result::addTransitive);
        return result;
    }
}

