/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.build.lib.bugreport.BugReport;
import com.google.devtools.build.lib.bugreport.Crash;
import com.google.devtools.build.lib.bugreport.CrashContext;
import com.google.devtools.build.lib.collect.compacthashset.CompactHashSet;
import com.google.devtools.build.lib.collect.nestedset.NestedSetStore;
import com.google.devtools.build.lib.collect.nestedset.Order;
import com.google.devtools.build.lib.concurrent.MoreFutures;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.DetailedExitCode;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

@AutoCodec
public final class NestedSet<E> {
    private static final byte[] NO_MEMO = new byte[0];
    @AutoCodec.VisibleForSerialization
    @SerializationConstant
    static final Object[] EMPTY_CHILDREN = new Object[0];
    private final int depthAndOrder;
    final Object children;
    @Nullable
    private byte[] memo;
    @VisibleForTesting
    static final int MAX_ELEMENTS_TO_STRING = 1000000;

    NestedSet(Order order) {
        this.depthAndOrder = order.ordinal();
        this.children = EMPTY_CHILDREN;
        this.memo = NO_MEMO;
    }

    NestedSet(Order order, Set<E> direct, Set<NestedSet<E>> transitive, InterruptStrategy interruptStrategy) throws InterruptedException {
        boolean preorder;
        Collection<E> directOrder = direct;
        Collection<NestedSet<E>> transitiveOrder = transitive;
        switch (order) {
            case LINK_ORDER: {
                directOrder = ImmutableList.copyOf(direct).reverse();
                transitiveOrder = ImmutableList.copyOf(transitive).reverse();
                preorder = false;
                break;
            }
            case STABLE_ORDER: 
            case COMPILE_ORDER: {
                preorder = false;
                break;
            }
            case NAIVE_LINK_ORDER: {
                preorder = true;
                break;
            }
            default: {
                throw new AssertionError((Object)order);
            }
        }
        Set alreadyInserted = ImmutableSet.of();
        Object[] children = new Object[direct.size() + transitive.size()];
        int approxDepth = 0;
        int n = 0;
        boolean shallow = true;
        for (int pass = 0; pass <= 1; ++pass) {
            if (pass == 0 == preorder && !direct.isEmpty()) {
                for (E member : directOrder) {
                    if (member instanceof Object[]) {
                        throw new IllegalArgumentException("cannot store Object[] in NestedSet");
                    }
                    if (member instanceof ByteString) {
                        throw new IllegalArgumentException("cannot store ByteString in NestedSet");
                    }
                    if (alreadyInserted.contains(member)) continue;
                    children[n++] = member;
                    approxDepth = Math.max(approxDepth, 2);
                }
                alreadyInserted = direct;
                continue;
            }
            if (pass == 1 != preorder || transitive.isEmpty()) continue;
            CompactHashSet<Object> hoisted = null;
            for (NestedSet<E> subset : transitiveOrder) {
                approxDepth = Math.max(approxDepth, 1 + subset.getApproxDepth());
                Object c = subset.getChildrenInternal(interruptStrategy);
                if (c instanceof Object[]) {
                    Object[] a = (Object[])c;
                    if (a.length < 2) {
                        throw new AssertionError(a.length);
                    }
                    children[n++] = a;
                    shallow = false;
                    continue;
                }
                if (alreadyInserted.contains(c)) continue;
                if (hoisted == null) {
                    hoisted = CompactHashSet.create();
                }
                if (!hoisted.add(c)) continue;
                children[n++] = c;
            }
            alreadyInserted = hoisted == null ? ImmutableSet.of() : hoisted;
        }
        if (n == 0) {
            approxDepth = 0;
            this.children = EMPTY_CHILDREN;
        } else if (n == 1) {
            --approxDepth;
            this.children = children[0];
        } else {
            if (n < children.length) {
                children = Arrays.copyOf(children, n);
            }
            this.children = children;
        }
        this.depthAndOrder = approxDepth << 2 | order.ordinal();
        if (shallow) {
            this.memo = NO_MEMO;
        }
    }

    private NestedSet(Order order, int depth, Object children, @Nullable byte[] memo) {
        this.depthAndOrder = depth << 2 | order.ordinal();
        this.children = children;
        this.memo = memo;
    }

    static <E> NestedSet<E> withFuture(Order order, int depth, ListenableFuture<Object[]> deserializationFuture) {
        return new NestedSet<E>(order, depth, deserializationFuture, null);
    }

    @AutoCodec.Instantiator
    static <E> NestedSet<E> forDeserialization(Order order, int approxDepth, Object children) {
        Preconditions.checkState(!(children instanceof ListenableFuture));
        boolean hasChildren = children instanceof Object[] && Arrays.stream((Object[])children).anyMatch(child -> child instanceof Object[]);
        byte[] memo = hasChildren ? null : NO_MEMO;
        return new NestedSet<E>(order, approxDepth, children, memo);
    }

    public Order getOrder() {
        return Order.getOrder(this.depthAndOrder & 3);
    }

    Object getChildren() {
        return this.getChildrenUninterruptibly();
    }

    Object getChildrenInterruptibly() throws InterruptedException {
        return this.children instanceof ListenableFuture ? MoreFutures.waitForFutureAndGet((ListenableFuture)this.children) : this.children;
    }

    private Object getChildrenUninterruptibly() {
        if (!(this.children instanceof ListenableFuture)) {
            return this.children;
        }
        try {
            return MoreFutures.waitForFutureAndGet((ListenableFuture)this.children);
        }
        catch (InterruptedException e) {
            FailureDetails.FailureDetail failureDetail = FailureDetails.FailureDetail.newBuilder().setMessage("Interrupted during NestedSet deserialization").setInterrupted(FailureDetails.Interrupted.newBuilder().setCode(FailureDetails.Interrupted.Code.INTERRUPTED)).build();
            BugReport.handleCrash(Crash.from(e, DetailedExitCode.of(failureDetail)), CrashContext.halt());
            throw new IllegalStateException("Should have halted", e);
        }
    }

    private Object getChildrenInternal(InterruptStrategy interruptStrategy) throws InterruptedException {
        switch (interruptStrategy) {
            case CRASH: {
                return this.getChildrenUninterruptibly();
            }
            case PROPAGATE: {
                return this.getChildrenInterruptibly();
            }
        }
        throw new IllegalStateException("Unknown interrupt strategy " + interruptStrategy);
    }

    public boolean isEmpty() {
        return this.children == EMPTY_CHILDREN;
    }

    public boolean isSingleton() {
        return NestedSet.isSingleton(this.children);
    }

    private static boolean isSingleton(Object children) {
        return !(children instanceof Object[]) && !(children instanceof ListenableFuture);
    }

    public int getApproxDepth() {
        return this.depthAndOrder >>> 2;
    }

    public boolean isFromStorage() {
        return this.children instanceof ListenableFuture;
    }

    public boolean isReady() {
        if (!this.isFromStorage()) {
            return true;
        }
        ListenableFuture future = (ListenableFuture)this.children;
        if (!future.isDone() || future.isCancelled()) {
            return false;
        }
        try {
            Futures.getDone(future);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public E getSingleton() {
        Preconditions.checkState(this.isSingleton());
        return (E)this.children;
    }

    public ImmutableList<E> toListInterruptibly() throws InterruptedException, NestedSetStore.MissingNestedSetException {
        Object actualChildren = this.children instanceof ListenableFuture ? MoreFutures.waitForFutureAndGetWithCheckedException((ListenableFuture)this.children, NestedSetStore.MissingNestedSetException.class) : this.children;
        return this.actualChildrenToList(actualChildren);
    }

    public ImmutableList<E> toListWithTimeout(Duration timeout) throws InterruptedException, TimeoutException, NestedSetStore.MissingNestedSetException {
        Object actualChildren;
        if (this.children instanceof ListenableFuture) {
            try {
                actualChildren = ((ListenableFuture)this.children).get(timeout.toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException e) {
                Throwables.propagateIfPossible(e.getCause(), InterruptedException.class, NestedSetStore.MissingNestedSetException.class);
                throw new IllegalStateException(e);
            }
        } else {
            actualChildren = this.children;
        }
        return this.actualChildrenToList(actualChildren);
    }

    public ImmutableList<E> toList() {
        return this.actualChildrenToList(this.getChildrenUninterruptibly());
    }

    private ImmutableList<E> actualChildrenToList(Object actualChildren) {
        if (actualChildren == EMPTY_CHILDREN) {
            return ImmutableList.of();
        }
        if (!(actualChildren instanceof Object[])) {
            return ImmutableList.of(actualChildren);
        }
        ImmutableList<E> list = this.expand((Object[])actualChildren);
        return this.getOrder() == Order.LINK_ORDER ? list.reverse() : list;
    }

    public ImmutableSet<E> toSet() {
        return ImmutableSet.copyOf(this.toList());
    }

    public int memoizedFlattenAndGetSize() {
        if (this.memo == null) {
            return this.toList().size();
        }
        if (this.memo == NO_MEMO) {
            Object children = this.getChildrenUninterruptibly();
            return children == EMPTY_CHILDREN ? 0 : (!(children instanceof Object[]) ? 1 : ((Object[])children).length);
        }
        NestedSet nestedSet = this;
        synchronized (nestedSet) {
            int size = 0;
            int i = this.memo.length - 1;
            while (true) {
                if ((size = size << 7 | this.memo[i] & 0x7F) < 0) {
                    throw new IllegalStateException("int overflow calculating size (" + size + "), memo: " + Arrays.toString(this.memo));
                }
                if ((this.memo[i] & 0x80) != 0) {
                    return size;
                }
                --i;
            }
        }
    }

    public boolean shallowEquals(@Nullable NestedSet<? extends E> other) {
        if (this == other) {
            return true;
        }
        return other != null && this.getOrder() == other.getOrder() && (this.children.equals(other.children) || !this.isSingleton() && !other.isSingleton() && this.children instanceof Object[] && other.children instanceof Object[] && Arrays.equals((Object[])this.children, (Object[])other.children));
    }

    public int shallowHashCode() {
        return this.isSingleton() || this.children instanceof ListenableFuture ? Objects.hash(new Object[]{this.getOrder(), this.children}) : Objects.hash(new Object[]{this.getOrder(), Arrays.hashCode((Object[])this.children)});
    }

    public String toString() {
        if (NestedSet.isSingleton(this.children)) {
            return "[" + this.children + "]";
        }
        if (this.children instanceof Future && !((Future)this.children).isDone()) {
            return "Deserializing NestedSet with future: " + this.children;
        }
        ImmutableList<E> elems = this.toList();
        if (elems.size() <= 1000000) {
            return elems.toString();
        }
        return (ImmutableList)elems.subList(0, 1000000) + " (truncated, full size " + elems.size() + ")";
    }

    private ImmutableList<E> expand(Object[] children) {
        if (this.memo == NO_MEMO) {
            return ImmutableList.copyOf(new ArraySharingCollection(children));
        }
        CompactHashSet<E> members = this.lockedExpand(children);
        if (members != null) {
            return ImmutableList.copyOf(members);
        }
        ImmutableList.Builder output = ImmutableList.builderWithExpectedSize(this.memoizedFlattenAndGetSize());
        NestedSet.replay(output, children, this.memo, 0);
        return output.build();
    }

    @Nullable
    private synchronized CompactHashSet<E> lockedExpand(Object[] children) {
        if (this.memo != null) {
            return null;
        }
        CompactHashSet members = CompactHashSet.createWithExpectedSize(128);
        CompactHashSet<Object> sets = CompactHashSet.createWithExpectedSize(128);
        sets.add(children);
        this.memo = new byte[3 + Math.min(NestedSet.ceildiv(children.length, 8), 8)];
        int pos = this.walk(sets, members, children, 0);
        int size = members.size();
        Preconditions.checkState(0 < size, "Size must be positive, was %s", size);
        int sizeVarIntLen = NestedSet.varintlen(size);
        int memoOffset = NestedSet.ceildiv(pos, 8);
        int idealMemoSize = memoOffset + sizeVarIntLen;
        if (this.memo.length < idealMemoSize || this.memo.length - 16 >= idealMemoSize) {
            this.memo = Arrays.copyOf(this.memo, idealMemoSize);
        }
        int top = -128;
        while (size > 0) {
            this.memo[memoOffset++] = (byte)((byte)(size & 0x7F) | top);
            size >>>= 7;
            top = 0;
        }
        return members;
    }

    private static int varintlen(int n) {
        int len = 0;
        while (n > 0) {
            n >>>= 7;
            ++len;
        }
        return len;
    }

    private static int ceildiv(int x, int y) {
        return (x + y - 1) / y;
    }

    private int walk(CompactHashSet<Object> sets, CompactHashSet<E> members, Object[] children, int pos) {
        for (Object child : children) {
            if (pos < 0) {
                throw new IllegalStateException("Negative position " + pos + " with memo length " + this.memo.length + " and child length " + children.length);
            }
            if (pos >> 3 >= this.memo.length) {
                this.memo = Arrays.copyOf(this.memo, this.memo.length * 2);
            }
            if (child instanceof Object[]) {
                if (sets.add(child)) {
                    int prepos = pos;
                    int presize = members.size();
                    pos = this.walk(sets, members, (Object[])child, pos + 1);
                    if (presize < members.size()) {
                        int n = prepos >> 3;
                        this.memo[n] = (byte)(this.memo[n] | (byte)(1 << (prepos & 7)));
                        continue;
                    }
                    pos = prepos + 1;
                    continue;
                }
                ++pos;
                continue;
            }
            if (members.add(child)) {
                int n = pos >> 3;
                this.memo[n] = (byte)(this.memo[n] | (byte)(1 << (pos & 7)));
            }
            ++pos;
        }
        return pos;
    }

    private static <E> int replay(ImmutableList.Builder<E> output, Object[] children, byte[] memo, int pos) {
        for (Object child : children) {
            if ((memo[pos >> 3] & 1 << (pos & 7)) == 0) {
                ++pos;
                continue;
            }
            if (child instanceof Object[]) {
                pos = NestedSet.replay(output, (Object[])child, memo, pos + 1);
                continue;
            }
            output.add(child);
            ++pos;
        }
        return pos;
    }

    public NestedSet<E> splitIfExceedsMaximumSize(int maxDegree) {
        Preconditions.checkArgument(maxDegree >= 2, "maxDegree must be at least 2");
        Object children = this.getChildren();
        if (!(children instanceof Object[])) {
            return this;
        }
        Object[] succs = (Object[])children;
        int nsuccs = succs.length;
        if (nsuccs <= maxDegree) {
            return this;
        }
        Object[][] pieces = new Object[NestedSet.ceildiv(nsuccs, maxDegree)][];
        for (int i = 0; i < pieces.length; ++i) {
            int max = Math.min((i + 1) * maxDegree, succs.length);
            pieces[i] = Arrays.copyOfRange(succs, i * maxDegree, max);
        }
        int depth = this.getApproxDepth() + 1;
        return new NestedSet<E>(this.getOrder(), depth, pieces, null).splitIfExceedsMaximumSize(maxDegree);
    }

    public ImmutableList<NestedSet<E>> getNonLeaves() {
        Object children = this.getChildren();
        if (!(children instanceof Object[])) {
            return ImmutableList.of();
        }
        ImmutableList.Builder res = ImmutableList.builder();
        for (Object c : (Object[])children) {
            if (!(c instanceof Object[])) continue;
            int depth = this.getApproxDepth() - 1;
            res.add(new NestedSet<E>(this.getOrder(), depth, c, null));
        }
        return res.build();
    }

    public ImmutableList<E> getLeaves() {
        Object children = this.getChildren();
        if (!(children instanceof Object[])) {
            return ImmutableList.of(children);
        }
        ImmutableList.Builder res = ImmutableList.builder();
        for (Object c : (Object[])children) {
            if (c instanceof Object[]) continue;
            res.add(c);
        }
        return res.build();
    }

    public Node toNode() {
        return new Node(this.children);
    }

    public static class Node {
        private final Object children;

        private Node(Object children) {
            this.children = children;
        }

        public int hashCode() {
            return this.children.hashCode();
        }

        public boolean equals(Object that) {
            return that instanceof Node && this.children.equals(((Node)that).children);
        }

        public String toString() {
            return "NestedSet.Node@" + this.hashCode();
        }
    }

    private static final class ArraySharingCollection<E>
    extends AbstractCollection<E> {
        private final Object[] array;

        ArraySharingCollection(Object[] array) {
            this.array = array;
        }

        @Override
        public Object[] toArray() {
            return this.array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    static enum InterruptStrategy {
        CRASH,
        PROPAGATE;

    }
}

