/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect.nestedset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.docgen.annot.GlobalMethods;
import com.google.devtools.build.lib.collect.nestedset.NestedSet;
import com.google.devtools.build.lib.collect.nestedset.NestedSetBuilder;
import com.google.devtools.build.lib.collect.nestedset.Order;
import com.google.devtools.build.lib.packages.semantics.BuildLanguageOptions;
import java.util.List;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkAnnotations;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.Debug;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="depset", category="BUILTIN", doc="<p>A specialized data structure that supports efficient merge operations and has a defined traversal order. Commonly used for accumulating data from transitive dependencies in rules and aspects. For more information see <a href=\"/extending/depsets\">here</a>. <p>The elements of a depset must be hashable and all of the same type (as defined by the built-in type(x) function), but depsets are not simply hash sets and do not support fast membership tests. If you need a general set datatype, you can simulate one using a dictionary where all keys map to <code>True</code>.<p>Depsets are immutable. They should be created using their <a href=\"../globals/bzl.html#depset\">constructor function</a> and merged or augmented with other depsets via the <code>transitive</code> argument. <p>The <code>order</code> parameter determines the kind of traversal that is done to convert the depset to an iterable. There are four possible values:<ul><li><code>\"default\"</code> (formerly <code>\"stable\"</code>): Order is unspecified (but deterministic).</li><li><code>\"postorder\"</code> (formerly <code>\"compile\"</code>): A left-to-right post-ordering. Precisely, this recursively traverses all children leftmost-first, then the direct elements leftmost-first.</li><li><code>\"preorder\"</code> (formerly <code>\"naive_link\"</code>): A left-to-right pre-ordering. Precisely, this traverses the direct elements leftmost-first, then recursively traverses the children leftmost-first.</li><li><code>\"topological\"</code> (formerly <code>\"link\"</code>): A topological ordering from the root down to the leaves. There is no left-to-right guarantee.</li></ul><p>Two depsets may only be merged if either both depsets have the same order, or one of them has <code>\"default\"</code> order. In the latter case the resulting depset's order will be the same as the other's order.<p>Depsets may contain duplicate values but these will be suppressed when iterating (using <code>to_list()</code>). Duplicates may interfere with the ordering semantics.")
public final class Depset
implements StarlarkValue,
Debug.ValueWithDebugAttributes {
    @Nullable
    private final Class<?> elemClass;
    private final NestedSet<?> set;
    private static final NestedSet<?> EMPTY = NestedSetBuilder.emptySet(Order.STABLE_ORDER);

    private Depset(@Nullable Class<?> elemClass, NestedSet<?> set) {
        this.elemClass = elemClass;
        this.set = set;
    }

    private static void checkElement(Object x, boolean strict) throws EvalException {
        if (strict && !Starlark.isImmutable(x)) {
            throw Starlark.errorf("depset elements must not be mutable values", new Object[0]);
        }
        if (x instanceof StarlarkList || x instanceof Dict) {
            throw Starlark.errorf("depsets cannot contain items of type '%s'", Starlark.type(x));
        }
    }

    public static <T> Depset of(Class<T> elemClass, NestedSet<T> set) {
        Preconditions.checkNotNull(elemClass, "elemClass cannot be null");
        return new Depset(set.isEmpty() ? null : ElementType.getTypeClass(elemClass), set);
    }

    private static Class<?> checkType(@Nullable Class<?> existingElemType, Class<?> newElemType) throws EvalException {
        Preconditions.checkNotNull(newElemType);
        if (existingElemType == null || existingElemType == newElemType) {
            return newElemType;
        }
        throw Starlark.errorf("cannot add an item of type '%s' to a depset of '%s'", ElementType.of(newElemType), ElementType.of(existingElemType));
    }

    public <T> NestedSet<T> getSet(Class<T> type) throws TypeException {
        ElementType elemType = this.getElementType();
        if (!this.set.isEmpty() && !elemType.canBeCastTo(type)) {
            throw new TypeException(String.format("got a depset of '%s', expected a depset of '%s'", elemType, Starlark.classType(type)));
        }
        NestedSet<?> res = this.set;
        return res;
    }

    public NestedSet<?> getSet() {
        return this.set;
    }

    public <T> ImmutableList<T> toList(Class<T> type) throws TypeException {
        return this.getSet(type).toList();
    }

    public ImmutableList<?> toList() {
        return this.set.toList();
    }

    public static <T> NestedSet<T> cast(Object x, Class<T> type, String what) throws EvalException {
        if (!(x instanceof Depset)) {
            throw Starlark.errorf("for %s, got %s, want a depset of %s", what, Starlark.type(x), Starlark.classType(type));
        }
        try {
            return ((Depset)x).getSet(type);
        }
        catch (TypeException ex) {
            throw Starlark.errorf("for '%s', %s", what, ex.getMessage());
        }
    }

    public static <T> NestedSet<T> noneableCast(Object x, Class<T> type, String what) throws EvalException {
        if (x == Starlark.NONE) {
            NestedSet<?> empty = EMPTY;
            return empty;
        }
        return Depset.cast(x, type, what);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean truth() {
        return !this.set.isEmpty();
    }

    public ElementType getElementType() {
        if (this.elemClass == null) {
            return ElementType.EMPTY;
        }
        return ElementType.of(this.elemClass);
    }

    @Nullable
    public Class<?> getElementClass() {
        return this.elemClass;
    }

    public String toString() {
        return Starlark.repr(this);
    }

    public Order getOrder() {
        return this.set.getOrder();
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public void repr(Printer printer) {
        printer.append("depset(");
        printer.printList(this.set.toList(), "[", ", ", "]");
        Order order = this.getOrder();
        if (order != Order.STABLE_ORDER) {
            printer.append(", order = ");
            printer.repr(order.getStarlarkName());
        }
        printer.append(")");
    }

    @Override
    public ImmutableList<Debug.DebugAttribute> getDebugAttributes() {
        return ImmutableList.of(new Debug.DebugAttribute("order", this.getOrder().getStarlarkName()), new Debug.DebugAttribute("directs", this.set.getLeaves()), new Debug.DebugAttribute("transitives", this.set.getNonLeaves()));
    }

    @StarlarkMethod(name="to_list", doc="Returns a list of the elements, without duplicates, in the depset's traversal order. Note that order is unspecified (but deterministic) for elements that were added more than once to the depset. Order is also unspecified for <code>\"default\"</code>-ordered depsets, and for elements of child depsets whose order differs from that of the parent depset. The list is a copy; modifying it has no effect on the depset and vice versa.", useStarlarkThread=true)
    public StarlarkList<Object> toListForStarlark(StarlarkThread thread) throws EvalException {
        return StarlarkList.copyOf(thread.mutability(), this.toList());
    }

    public static Depset fromDirectAndTransitive(Order order, List<Object> direct, List<Depset> transitive, boolean strict) throws EvalException {
        NestedSetBuilder<Object> builder = new NestedSetBuilder<Object>(order);
        Class<?> type = null;
        for (Object object : direct) {
            Depset.checkElement(object, strict);
            Class<?> xt = ElementType.getTypeClass(object.getClass());
            type = Depset.checkType(type, xt);
        }
        builder.addAll(direct);
        for (Depset depset : transitive) {
            if (depset.isEmpty()) continue;
            type = Depset.checkType(type, depset.elemClass);
            if (!order.isCompatible(depset.getOrder())) {
                throw Starlark.errorf("Order '%s' is incompatible with order '%s'", order.getStarlarkName(), depset.getOrder().getStarlarkName());
            }
            builder.addTransitive(depset.getSet());
        }
        return new Depset(type, builder.build());
    }

    private static Depset depset(String orderString, Object direct, Object transitive, StarlarkSemantics semantics) throws EvalException {
        Order order;
        try {
            order = Order.parse(orderString);
        }
        catch (IllegalArgumentException ex) {
            throw new EvalException(ex);
        }
        Depset result = Depset.fromDirectAndTransitive(order, Sequence.noneableCast(direct, Object.class, "direct"), Sequence.noneableCast(transitive, Depset.class, "transitive"), semantics.getBool("+incompatible_always_check_depset_elements"));
        int depth = result.getSet().getApproxDepth();
        int limit = semantics.get(BuildLanguageOptions.NESTED_SET_DEPTH_LIMIT);
        if (depth > limit) {
            throw Starlark.errorf("depset depth %d exceeds limit (%d)", depth, limit);
        }
        return result;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Depset && this.set.equals(((Depset)other).set);
    }

    @GlobalMethods(environment={GlobalMethods.Environment.BUILD, GlobalMethods.Environment.BZL})
    public static final class DepsetLibrary {
        public static final DepsetLibrary INSTANCE = new DepsetLibrary();

        private DepsetLibrary() {
        }

        @StarlarkMethod(name="depset", doc="Creates a <a href=\"../builtins/depset.html\">depset</a>. The <code>direct</code> parameter is a list of direct elements of the depset, and <code>transitive</code> parameter is a list of depsets whose elements become indirect elements of the created depset. The order in which elements are returned when the depset is converted to a list is specified by the <code>order</code> parameter. See the <a href=\"https://bazel.build/extending/depsets\">Depsets overview</a> for more information.\n<p>All elements (direct and indirect) of a depset must be of the same type, as obtained by the expression <code>type(x)</code>.\n<p>Because a hash-based set is used to eliminate duplicates during iteration, all elements of a depset should be hashable. However, this invariant is not currently checked consistently in all constructors. Use the --incompatible_always_check_depset_elements flag to enable consistent checking; this will be the default behavior in future releases;  see <a href='https://github.com/bazelbuild/bazel/issues/10313'>Issue 10313</a>.\n<p>In addition, elements must currently be immutable, though this restriction will be relaxed in future.\n<p> The order of the created depset should be <i>compatible</i> with the order of its <code>transitive</code> depsets. <code>\"default\"</code> order is compatible with any other order, all other orders are only compatible with themselves.\n<p> Note on backward/forward compatibility. This function currently accepts a positional <code>items</code> parameter. It is deprecated and will be removed in the future, and after its removal <code>direct</code> will become a sole positional parameter of the <code>depset</code> function. Thus, both of the following calls are equivalent and future-proof:<br>\n<pre class=language-python>depset(['a', 'b'], transitive = [...])\ndepset(direct = ['a', 'b'], transitive = [...])\n</pre>", parameters={@Param(name="direct", defaultValue="None", named=true, allowedTypes={@ParamType(type=Sequence.class), @ParamType(type=NoneType.class)}, doc="A list of <i>direct</i> elements of a depset. "), @Param(name="order", defaultValue="\"default\"", doc="The traversal strategy for the new depset. See <a href=\"../builtins/depset.html\">here</a> for the possible values.", named=true), @Param(name="transitive", named=true, positional=false, allowedTypes={@ParamType(type=Sequence.class, generic1=Depset.class), @ParamType(type=NoneType.class)}, doc="A list of depsets whose elements will become indirect elements of the depset.", defaultValue="None")}, useStarlarkThread=true)
        public Depset depset(Object direct, String orderString, Object transitive, StarlarkThread thread) throws EvalException {
            return Depset.depset(orderString, direct, transitive, thread.getSemantics());
        }
    }

    public static final class ElementType {
        @Nullable
        private final Class<?> cls;
        public static final ElementType EMPTY = new ElementType(null);
        public static final ElementType STRING = ElementType.of(String.class);

        private ElementType(@Nullable Class<?> cls) {
            this.cls = cls;
        }

        public String toString() {
            return this.cls == null ? "empty" : Starlark.classType(this.cls);
        }

        public static ElementType of(Class<?> cls) {
            return new ElementType(ElementType.getTypeClass(cls));
        }

        private static Class<?> getTypeClass(Class<?> cls) {
            if (cls == String.class || cls == Boolean.class) {
                return cls;
            }
            if (cls == StarlarkInt.class) {
                return cls;
            }
            Class<?> superclass = StarlarkAnnotations.getParentWithStarlarkBuiltin(cls);
            if (superclass != null) {
                return superclass;
            }
            if (!StarlarkValue.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException("invalid Depset element type: " + cls.getName() + " is not a subclass of StarlarkValue");
            }
            return cls;
        }

        private boolean canBeCastTo(Class<?> cls) {
            return this.cls == null || cls == Object.class || ElementType.getTypeClass(cls).isAssignableFrom(this.cls);
        }

        public int hashCode() {
            return this.cls == null ? 0 : this.cls.hashCode();
        }

        public boolean equals(Object that) {
            return that instanceof ElementType && this.cls == ((ElementType)that).cls;
        }
    }

    public static class TypeException
    extends Exception {
        TypeException(String message) {
            super(message);
        }
    }
}

