/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.collect.CollectionUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class IterablesChain<T>
implements Iterable<T> {
    private final Iterable<T> chain;

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return IterablesChain.builder().add(a).add(b).build();
    }

    IterablesChain(Iterable<T> chain) {
        this.chain = chain;
    }

    @Override
    public Iterator<T> iterator() {
        return this.chain.iterator();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public String toString() {
        return "[" + Joiner.on(", ").join(this) + "]";
    }

    public static class Builder<T> {
        private List<Iterable<? extends T>> iterables = new ArrayList<Iterable<? extends T>>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder<T> add(Iterable<? extends T> iterable) {
            CollectionUtils.checkImmutable(iterable);
            if (!Iterables.isEmpty(iterable)) {
                this.iterables.add(iterable);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> addElement(T element) {
            this.iterables.add(ImmutableList.of(element));
            return this;
        }

        public boolean isEmpty() {
            return this.iterables.isEmpty();
        }

        public Iterable<T> build() {
            int size = this.iterables.size();
            if (size == 0) {
                return ImmutableList.of();
            }
            if (size == 1) {
                return this.iterables.get(0);
            }
            return new IterablesChain<T>(Iterables.concat(ImmutableList.copyOf(this.iterables)));
        }
    }
}

