/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.collect.IterablesChain;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class IterableCodecs {
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final Object DONE = new Object();

    IterableCodecs() {
    }

    private static void serialize(SerializationContext context, Iterable obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        for (Object elt : obj) {
            context.serialize(elt, codedOut);
        }
        context.serialize(DONE, codedOut);
    }

    private static ImmutableList<Object> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        Object next = context.deserialize(codedIn);
        while (next != DONE) {
            builder.add(next);
            next = context.deserialize(codedIn);
        }
        return builder.build();
    }

    static class IterablesChainCodec
    implements ObjectCodec<IterablesChain> {
        IterablesChainCodec() {
        }

        @Override
        public Class<IterablesChain> getEncodedClass() {
            return IterablesChain.class;
        }

        @Override
        public void serialize(SerializationContext context, IterablesChain obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            IterableCodecs.serialize(context, obj, codedOut);
        }

        @Override
        public IterablesChain deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            return new IterablesChain<Object>(IterableCodecs.deserialize(context, codedIn));
        }
    }

    static class FluentIterableCodec
    implements ObjectCodec<FluentIterable> {
        FluentIterableCodec() {
        }

        @Override
        public Class<FluentIterable> getEncodedClass() {
            return FluentIterable.class;
        }

        @Override
        public void serialize(SerializationContext context, FluentIterable obj, CodedOutputStream codedOut) throws SerializationException, IOException {
            IterableCodecs.serialize(context, obj, codedOut);
        }

        @Override
        public FluentIterable deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            return FluentIterable.from(IterableCodecs.deserialize(context, codedIn));
        }
    }
}

