/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class ImmutableSortedKeyListMultimap<K extends Comparable<K>, V>
implements ListMultimap<K, V> {
    private static final ImmutableSortedKeyListMultimap EMPTY_MULTIMAP = new ImmutableSortedKeyListMultimap(new Comparable[0], new List[0]);
    private final K[] sortedKeys;
    private final List<V>[] values;

    public static <K extends Comparable<K>, V> ImmutableSortedKeyListMultimap<K, V> of() {
        return EMPTY_MULTIMAP;
    }

    public static <K extends Comparable<K>, V> ImmutableSortedKeyListMultimap<K, V> copyOf(Multimap<K, V> data) {
        if (data.isEmpty()) {
            return EMPTY_MULTIMAP;
        }
        if (data instanceof ImmutableSortedKeyListMultimap) {
            return (ImmutableSortedKeyListMultimap)data;
        }
        Set<K> keySet = data.keySet();
        int size = keySet.size();
        Object[] sortedKeys = new Comparable[size];
        int index = 0;
        for (Comparable key : keySet) {
            sortedKeys[index++] = Preconditions.checkNotNull(key);
        }
        Arrays.sort(sortedKeys);
        List[] values = new List[size];
        for (int i = 0; i < size; ++i) {
            values[i] = ImmutableList.copyOf(data.get(sortedKeys[i]));
        }
        return new ImmutableSortedKeyListMultimap((Comparable[])sortedKeys, values);
    }

    public static <K extends Comparable<K>, V> Builder<K, V> builder() {
        return new Builder();
    }

    private ImmutableSortedKeyListMultimap(K[] sortedKeys, List<V>[] values) {
        this.sortedKeys = sortedKeys;
        this.values = values;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(Arrays.stream(this.values).mapToLong(List::size).sum());
    }

    @Override
    public boolean isEmpty() {
        return this.sortedKeys.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = Arrays.binarySearch(this.sortedKeys, key);
        return index >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return Arrays.stream(this.values).anyMatch(list -> list.contains(value));
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        int index = Arrays.binarySearch(this.sortedKeys, key);
        return index >= 0 && this.values[index].contains(value);
    }

    @Override
    public boolean put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<V> replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<V> removeAll(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<V> get(K key) {
        int index = Arrays.binarySearch(this.sortedKeys, key);
        return index >= 0 ? this.values[index] : ImmutableList.of();
    }

    @Override
    public Set<K> keySet() {
        return ImmutableSet.copyOf(this.sortedKeys);
    }

    @Override
    public Multiset<K> keys() {
        return ImmutableMultiset.copyOf(this.sortedKeys);
    }

    @Override
    public Collection<V> values() {
        return new ValuesCollection();
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.sortedKeys.length; ++i) {
            for (V value : this.values[i]) {
                builder.add(new AbstractMap.SimpleImmutableEntry<K, V>(this.sortedKeys[i], value));
            }
        }
        return builder.build();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return new AsMap();
    }

    public String toString() {
        return this.asMap().toString();
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return this.asMap().equals(that.asMap());
        }
        return false;
    }

    private class ValuesCollection
    extends AbstractCollection<V> {
        ValuesCollection() {
        }

        @Override
        public int size() {
            return ImmutableSortedKeyListMultimap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ImmutableSortedKeyListMultimap.this.sortedKeys.length == 0;
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableSortedKeyListMultimap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            if (this.isEmpty()) {
                return Collections.emptyIterator();
            }
            return new AbstractIterator<V>(){
                private int currentList = 0;
                private int currentIndex = 0;

                @Override
                protected V computeNext() {
                    if (this.currentList >= ImmutableSortedKeyListMultimap.this.values.length) {
                        return this.endOfData();
                    }
                    Object result = ImmutableSortedKeyListMultimap.this.values[this.currentList].get(this.currentIndex);
                    ++this.currentIndex;
                    if (this.currentIndex >= ImmutableSortedKeyListMultimap.this.values[this.currentList].size()) {
                        this.currentIndex = 0;
                        ++this.currentList;
                    }
                    return result;
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class AsMap
    extends AbstractMap<K, Collection<V>> {
        AsMap() {
        }

        @Override
        public int size() {
            return ImmutableSortedKeyListMultimap.this.sortedKeys.length;
        }

        @Override
        public boolean containsKey(Object key) {
            return ImmutableSortedKeyListMultimap.this.containsKey(key);
        }

        @Override
        @Nullable
        public Collection<V> get(Object key) {
            int index = Arrays.binarySearch(ImmutableSortedKeyListMultimap.this.sortedKeys, key);
            return index >= 0 ? ImmutableSortedKeyListMultimap.this.values[index] : null;
        }

        @Override
        @Nullable
        public Collection<V> remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < ImmutableSortedKeyListMultimap.this.sortedKeys.length; ++i) {
                builder.add(new AbstractMap.SimpleImmutableEntry(ImmutableSortedKeyListMultimap.this.sortedKeys[i], ImmutableSortedKeyListMultimap.this.values[i]));
            }
            return builder.build();
        }
    }

    public static final class Builder<K extends Comparable<K>, V> {
        private final Multimap<K, V> builderMultimap = ArrayListMultimap.create();

        Builder() {
        }

        public ImmutableSortedKeyListMultimap<K, V> build() {
            return ImmutableSortedKeyListMultimap.copyOf(this.builderMultimap);
        }

        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            this.builderMultimap.put((Comparable)Preconditions.checkNotNull(key), Preconditions.checkNotNull(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(K key, Collection<? extends V> values) {
            Collection<V> valueList = this.builderMultimap.get((Comparable)Preconditions.checkNotNull(key));
            for (V value : values) {
                valueList.add(Preconditions.checkNotNull(value));
            }
            return this;
        }

        public Builder<K, V> putAll(K key, V ... values) {
            return this.putAll((K)((Comparable)Preconditions.checkNotNull(key)), (Collection<? extends V>)Arrays.asList(values));
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Multimap<? extends K, ? extends V> multimap) {
            multimap.asMap().forEach((key, collectionValue) -> this.putAll((K)key, (Collection<? extends V>)collectionValue));
            return this;
        }
    }
}

