/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.devtools.build.lib.collect.CompactImmutableMap;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImmutableSharedKeyMap<K, V>
extends CompactImmutableMap<K, V> {
    private static final Interner<OffsetTable<?>> offsetTables = BlazeInterners.newWeakInterner();
    private final OffsetTable<K> offsetTable;
    @AutoCodec.VisibleForSerialization
    protected final Object[] values;

    protected ImmutableSharedKeyMap(Object[] keys, Object[] values) {
        Preconditions.checkArgument(keys.length == values.length);
        this.values = values;
        this.offsetTable = ImmutableSharedKeyMap.createOffsetTable(keys);
    }

    private static <K> OffsetTable<K> createOffsetTable(Object[] keys) {
        OffsetTable offsetTable = new OffsetTable(keys);
        OffsetTable internedTable = offsetTables.intern(offsetTable);
        internedTable.initIndexMap();
        return internedTable;
    }

    @Override
    public V get(K key) {
        int offset = this.offsetTable.offsetForKey(key);
        return (V)(offset != -1 ? this.values[offset] : null);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public K keyAt(int index) {
        return (K)this.offsetTable.keys[index];
    }

    @Override
    public V valueAt(int index) {
        return (V)this.values[index];
    }

    @Deprecated
    @AutoCodec.VisibleForSerialization
    public Object[] getKeys() {
        return this.offsetTable.keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSharedKeyMap that = (ImmutableSharedKeyMap)o;
        return this.offsetTable == that.offsetTable && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hashCode(this.offsetTable, Arrays.hashCode(this.values));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        private final List<Object> entries = new ArrayList<Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            this.entries.add(key);
            this.entries.add(value);
            return this;
        }

        public ImmutableSharedKeyMap<K, V> build() {
            int count = this.entries.size() / 2;
            Object[] keys = new Object[count];
            Object[] values = new Object[count];
            int entryIndex = 0;
            for (int i = 0; i < count; ++i) {
                keys[i] = this.entries.get(entryIndex++);
                values[i] = this.entries.get(entryIndex++);
            }
            return new ImmutableSharedKeyMap(keys, values);
        }
    }

    private static final class OffsetTable<K> {
        private final Object[] keys;
        private volatile ImmutableMap<K, Integer> indexMap;

        private OffsetTable(Object[] keys) {
            this.keys = keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initIndexMap() {
            if (this.indexMap == null) {
                OffsetTable offsetTable = this;
                synchronized (offsetTable) {
                    if (this.indexMap == null) {
                        ImmutableMap.Builder<Object, Integer> builder = ImmutableMap.builder();
                        for (int i = 0; i < this.keys.length; ++i) {
                            Object key = this.keys[i];
                            builder.put(key, i);
                        }
                        this.indexMap = builder.buildOrThrow();
                    }
                }
            }
        }

        private ImmutableMap<K, Integer> getIndexMap() {
            return this.indexMap;
        }

        int offsetForKey(K key) {
            return this.getIndexMap().getOrDefault(key, -1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OffsetTable)) {
                return false;
            }
            OffsetTable that = (OffsetTable)o;
            return Arrays.equals(this.keys, that.keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }
    }
}

