/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.PriorityQueue;

public abstract class Extrema<T> {
    private static final Extrema<Object> EMPTY = new EmptyExtrema<Object>();

    public static <T extends Comparable<T>> Extrema<T> min(int k) {
        return Extrema.min(k, Comparator.naturalOrder());
    }

    public static <T> Extrema<T> min(int k, Comparator<T> comparator) {
        return Extrema.create(k, comparator);
    }

    public static <T extends Comparable<T>> Extrema<T> max(int k) {
        return Extrema.max(k, Comparator.naturalOrder());
    }

    public static <T> Extrema<T> max(int k, Comparator<T> comparator) {
        return Extrema.create(k, comparator.reversed());
    }

    public abstract void aggregate(T var1);

    public abstract ImmutableList<T> getExtremeElements();

    public abstract boolean isEmpty();

    public abstract void clear();

    private static <T> Extrema<T> create(int k, Comparator<T> comparator) {
        Preconditions.checkArgument(k >= 0, "invalid k (%s), must be >=0", k);
        return k == 0 ? EMPTY : new RegularExtrema<T>(k, comparator);
    }

    private static class RegularExtrema<T>
    extends Extrema<T> {
        private final int k;
        private final Comparator<T> extremaComparator;
        private final PriorityQueue<T> priorityQueue;

        private RegularExtrema(int k, Comparator<T> extremaComparator) {
            this.k = k;
            this.extremaComparator = extremaComparator;
            this.priorityQueue = new PriorityQueue<T>(k, extremaComparator.reversed());
        }

        @Override
        public void aggregate(T element) {
            if (this.priorityQueue.size() < this.k) {
                this.priorityQueue.add(element);
            } else if (this.extremaComparator.compare(element, this.priorityQueue.peek()) < 0) {
                this.priorityQueue.remove();
                this.priorityQueue.add(element);
            }
        }

        @Override
        public ImmutableList<T> getExtremeElements() {
            return ImmutableList.sortedCopyOf(this.extremaComparator, this.priorityQueue);
        }

        @Override
        public void clear() {
            this.priorityQueue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.priorityQueue.isEmpty();
        }
    }

    private static class EmptyExtrema<T>
    extends Extrema<T> {
        private EmptyExtrema() {
        }

        @Override
        public void aggregate(T element) {
        }

        @Override
        public ImmutableList<T> getExtremeElements() {
            return ImmutableList.of();
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

