/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.devtools.build.lib.collect.EquivalenceRelation;
import com.google.devtools.build.lib.collect.IterablesChain;
import com.google.devtools.build.lib.collect.compacthashset.CompactHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    private static <T> Collection<Set<T>> partitionWithComparator(Collection<T> elements, Comparator<T> equivalenceRelation) {
        ArrayList<Set<T>> eqClasses = new ArrayList<Set<T>>();
        for (T element : elements) {
            boolean found = false;
            for (Set set : eqClasses) {
                if (equivalenceRelation.compare(set.iterator().next(), element) != 0) continue;
                set.add(element);
                found = true;
                break;
            }
            if (found) continue;
            HashSet<T> eqClass = new HashSet<T>();
            eqClass.add(element);
            eqClasses.add(eqClass);
        }
        return eqClasses;
    }

    public static <T> Collection<Set<T>> partition(Collection<T> elements, EquivalenceRelation<T> equivalenceRelation) {
        return CollectionUtils.partitionWithComparator(elements, equivalenceRelation::compare);
    }

    public static <T> Set<T> duplicatedElementsOf(List<T> input) {
        int count = input.size();
        if (count < 2) {
            return ImmutableSet.of();
        }
        HashSet<T> duplicates = null;
        CompactHashSet<T> elementSet = CompactHashSet.createWithExpectedSize(count);
        for (T el : input) {
            if (elementSet.add(el)) continue;
            if (duplicates == null) {
                duplicates = new HashSet<T>();
            }
            duplicates.add(el);
        }
        return duplicates == null ? ImmutableSet.of() : duplicates;
    }

    public static <T> ImmutableSet<T> asSetWithoutNulls(T ... elements) {
        return Arrays.stream(elements).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean isImmutable(Iterable<?> iterable) {
        return iterable instanceof ImmutableCollection || iterable instanceof IterablesChain;
    }

    public static void checkImmutable(Iterable<?> iterable) {
        Preconditions.checkState(CollectionUtils.isImmutable(iterable), iterable.getClass());
    }

    public static <T> Iterable<T> makeImmutable(Iterable<T> iterable) {
        return CollectionUtils.isImmutable(iterable) ? iterable : ImmutableList.copyOf(iterable);
    }

    public static <KEY_1, KEY_2, VALUE> Map<KEY_1, Map<KEY_2, VALUE>> copyOf(Map<KEY_1, ? extends Map<KEY_2, VALUE>> map) {
        return new HashMap(Maps.transformValues(map, HashMap::new));
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

