/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.devtools.build.lib.cmdline.BatchCallback;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.cmdline.ResolvedTargets;
import com.google.devtools.build.lib.cmdline.TargetParsingException;
import com.google.devtools.build.lib.io.InconsistentFilesystemException;
import com.google.devtools.build.lib.io.ProcessPackageDirectoryException;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.util.Collection;

public abstract class TargetPatternResolver<T> {
    public abstract void warn(String var1);

    public abstract T getTargetOrNull(Label var1) throws InterruptedException, InconsistentFilesystemException;

    public abstract ResolvedTargets<T> getExplicitTarget(Label var1) throws TargetParsingException, InterruptedException;

    public abstract Collection<T> getTargetsInPackage(String var1, PackageIdentifier var2, boolean var3) throws TargetParsingException, InterruptedException;

    public abstract <E extends Exception> void findTargetsBeneathDirectory(RepositoryName var1, String var2, String var3, boolean var4, ImmutableSet<PathFragment> var5, ImmutableSet<PathFragment> var6, BatchCallback<T, E> var7, Class<E> var8) throws TargetParsingException, E, InterruptedException, ProcessPackageDirectoryException;

    public <E extends Exception> ListenableFuture<Void> findTargetsBeneathDirectoryAsync(RepositoryName repository, String originalPattern, String directory, boolean rulesOnly, ImmutableSet<PathFragment> forbiddenSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass, ListeningExecutorService executor) {
        try {
            this.findTargetsBeneathDirectory(repository, originalPattern, directory, rulesOnly, forbiddenSubdirectories, excludedSubdirectories, callback, exceptionClass);
            return Futures.immediateVoidFuture();
        }
        catch (TargetParsingException e) {
            return Futures.immediateFailedFuture(e);
        }
        catch (InterruptedException e) {
            return Futures.immediateCancelledFuture();
        }
        catch (ProcessPackageDirectoryException e) {
            throw new IllegalStateException("Async find targets beneath directory isn't called from within Skyframe: traversing " + directory + " for " + originalPattern, e);
        }
        catch (Exception e) {
            if (exceptionClass.isInstance(e)) {
                return Futures.immediateFailedFuture(e);
            }
            throw new IllegalStateException(e);
        }
    }

    public abstract boolean isPackage(PackageIdentifier var1) throws InterruptedException, InconsistentFilesystemException;

    public abstract String getTargetKind(T var1);
}

