/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.devtools.build.lib.cmdline.BatchCallback;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelParser;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.cmdline.ResolvedTargets;
import com.google.devtools.build.lib.cmdline.TargetParsingException;
import com.google.devtools.build.lib.cmdline.TargetPatternResolver;
import com.google.devtools.build.lib.io.InconsistentFilesystemException;
import com.google.devtools.build.lib.io.ProcessPackageDirectoryException;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.supplier.InterruptibleSupplier;
import com.google.devtools.build.lib.util.StringUtilities;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.CompileTimeConstant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public abstract class TargetPattern {
    private static final Splitter SLASH_SPLITTER = Splitter.on('/');
    private static final Joiner SLASH_JOINER = Joiner.on('/');
    private static final Parser DEFAULT_PARSER = TargetPattern.mainRepoParser(PathFragment.EMPTY_FRAGMENT);
    private final String originalPattern;

    public static Parser defaultParser() {
        return DEFAULT_PARSER;
    }

    public static Parser mainRepoParser(PathFragment offset) {
        return new Parser(offset, RepositoryName.MAIN, RepositoryMapping.ALWAYS_FALLBACK);
    }

    @VisibleForTesting
    static String normalize(String path) {
        Preconditions.checkArgument(!path.startsWith("/"), path);
        Preconditions.checkArgument(!path.startsWith("@"), path);
        Iterator<String> it = SLASH_SPLITTER.split(path).iterator();
        ArrayList<String> pieces = new ArrayList<String>();
        while (it.hasNext()) {
            String piece = it.next();
            if (".".equals(piece) || piece.isEmpty()) continue;
            if ("..".equals(piece)) {
                if (pieces.isEmpty()) {
                    pieces.add(piece);
                    continue;
                }
                String predecessor = (String)pieces.remove(pieces.size() - 1);
                if (!"..".equals(predecessor)) continue;
                pieces.add(piece);
                pieces.add(piece);
                continue;
            }
            pieces.add(piece);
        }
        return SLASH_JOINER.join(pieces);
    }

    private TargetPattern(String originalPattern) {
        this.originalPattern = Preconditions.checkNotNull(originalPattern);
    }

    public abstract Type getType();

    public String getOriginalPattern() {
        return this.originalPattern;
    }

    public abstract <T, E extends Exception> void eval(TargetPatternResolver<T> var1, InterruptibleSupplier<ImmutableSet<PathFragment>> var2, ImmutableSet<PathFragment> var3, BatchCallback<T, E> var4, Class<E> var5) throws TargetParsingException, E, InterruptedException, ProcessPackageDirectoryException, InconsistentFilesystemException;

    public final <T, E extends Exception> ListenableFuture<Void> evalAdaptedForAsync(TargetPatternResolver<T> resolver, InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass) {
        try {
            this.eval(resolver, ignoredSubdirectories, excludedSubdirectories, callback, exceptionClass);
            return Futures.immediateFuture(null);
        }
        catch (TargetParsingException e) {
            return Futures.immediateFailedFuture(e);
        }
        catch (InconsistentFilesystemException | ProcessPackageDirectoryException e) {
            throw new IllegalStateException("Cannot throw filesystem-related exceptions outside of Skyframe evaluation for " + this, e);
        }
        catch (InterruptedException e) {
            return Futures.immediateCancelledFuture();
        }
        catch (Exception e) {
            if (exceptionClass.isInstance(e)) {
                return Futures.immediateFailedFuture((Throwable)exceptionClass.cast(e));
            }
            throw new IllegalStateException(e);
        }
    }

    public <T, E extends Exception> ListenableFuture<Void> evalAsync(TargetPatternResolver<T> resolver, InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass, ListeningExecutorService executor) {
        return this.evalAdaptedForAsync(resolver, ignoredSubdirectories, excludedSubdirectories, callback, exceptionClass);
    }

    public String getPathForPathAsTarget() {
        throw new IllegalStateException();
    }

    public Label getSingleTargetLabel() {
        throw new IllegalStateException();
    }

    public PackageIdentifier getDirectory() {
        throw new IllegalStateException();
    }

    public abstract RepositoryName getRepository();

    public abstract boolean getRulesOnly();

    protected final MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("originalPattern", this.originalPattern);
    }

    private static Label label(PackageIdentifier pkg, String targetName) throws TargetParsingException {
        try {
            return Label.create(pkg, targetName);
        }
        catch (LabelSyntaxException e) {
            throw new TargetParsingException("invalid target name: '" + StringUtilities.sanitizeControlChars(targetName) + "'; " + StringUtilities.sanitizeControlChars(e.getMessage()), FailureDetails.TargetPatterns.Code.TARGET_FORMAT_INVALID);
        }
    }

    public static enum Type {
        PATH_AS_TARGET,
        SINGLE_TARGET,
        TARGETS_BELOW_DIRECTORY,
        TARGETS_IN_PACKAGE;

    }

    @Immutable
    public static final class Parser {
        private static final ImmutableList<String> ALL_RULES_IN_SUFFIXES = ImmutableList.of("all");
        private static final ImmutableList<String> ALL_TARGETS_IN_SUFFIXES = ImmutableList.of("*", "all-targets");
        private final PathFragment relativeDirectory;
        private final RepositoryName currentRepo;
        private final RepositoryMapping repoMapping;

        public Parser(PathFragment relativeDirectory, RepositoryName currentRepo, RepositoryMapping repoMapping) {
            Preconditions.checkArgument(currentRepo.isMain() || relativeDirectory.isEmpty(), "parsing target patterns in a non-main repo with a relative directory is unsupported");
            this.relativeDirectory = relativeDirectory;
            this.currentRepo = currentRepo;
            this.repoMapping = repoMapping;
        }

        public TargetPattern parse(String pattern) throws TargetParsingException {
            LabelParser.Parts parts;
            try {
                parts = LabelParser.Parts.parse(pattern);
            }
            catch (LabelSyntaxException e) {
                throw new TargetParsingException(e.getMessage(), FailureDetails.TargetPatterns.Code.LABEL_SYNTAX_ERROR);
            }
            if (!parts.pkgIsAbsolute() && this.currentRepo.isMain() && parts.pkg().isEmpty() && !parts.pkgEndsWithTripleDots() && !pattern.contains(":")) {
                return new InterpretPathAsTarget(pattern, this.relativeDirectory.getRelative(parts.target()).getPathString());
            }
            PackageIdentifier packageIdentifier = this.createPackageIdentifierFromParts(parts);
            if (parts.pkgEndsWithTripleDots()) {
                if (parts.target().isEmpty() || ALL_RULES_IN_SUFFIXES.contains(parts.target())) {
                    return new TargetsBelowDirectory(pattern, packageIdentifier, true);
                }
                if (ALL_TARGETS_IN_SUFFIXES.contains(parts.target())) {
                    return new TargetsBelowDirectory(pattern, packageIdentifier, false);
                }
                throw new TargetParsingException("Invalid target pattern " + pattern + ": '...' can only be used with wildcard targets", FailureDetails.TargetPatterns.Code.LABEL_SYNTAX_ERROR);
            }
            if (pattern.contains(":") && ALL_RULES_IN_SUFFIXES.contains(parts.target())) {
                return new TargetsInPackage(pattern, packageIdentifier, parts.target(), parts.pkgIsAbsolute(), true);
            }
            if (pattern.contains(":") && ALL_TARGETS_IN_SUFFIXES.contains(parts.target())) {
                return new TargetsInPackage(pattern, packageIdentifier, parts.target(), parts.pkgIsAbsolute(), false);
            }
            return new SingleTarget(pattern, Label.createUnvalidated(packageIdentifier, parts.target()));
        }

        private PackageIdentifier createPackageIdentifierFromParts(LabelParser.Parts parts) throws TargetParsingException {
            RepositoryName repo;
            if (parts.repo() == null) {
                repo = this.currentRepo;
            } else if (parts.repoIsCanonical()) {
                repo = RepositoryName.createUnvalidated(parts.repo());
            } else {
                repo = this.repoMapping.get(parts.repo());
                if (!repo.isVisible()) {
                    throw new TargetParsingException(String.format("No repository visible as '@%s' from %s", repo.getName(), repo.getOwnerRepoDisplayString()), FailureDetails.TargetPatterns.Code.PACKAGE_NOT_FOUND);
                }
            }
            PathFragment packagePathFragment = parts.pkgIsAbsolute() ? PathFragment.create(parts.pkg()) : this.relativeDirectory.getRelative(parts.pkg());
            return PackageIdentifier.create(repo, packagePathFragment);
        }

        public RepositoryMapping getRepoMapping() {
            return this.repoMapping;
        }

        public RepositoryName getCurrentRepo() {
            return this.currentRepo;
        }

        public PathFragment getRelativeDirectory() {
            return this.relativeDirectory;
        }

        @CheckReturnValue
        public TargetPattern parseConstantUnchecked(@CompileTimeConstant String pattern) {
            try {
                return this.parse(pattern);
            }
            catch (TargetParsingException e) {
                throw new IllegalStateException(e);
            }
        }

        public String absolutize(String pattern) {
            if (pattern.startsWith("//")) {
                return pattern;
            }
            return pattern.startsWith(":") || this.relativeDirectory.isEmpty() ? "//" + this.relativeDirectory.getPathString() + pattern : "//" + this.relativeDirectory.getPathString() + "/" + pattern;
        }
    }

    public static final class TargetsBelowDirectory
    extends TargetPattern {
        private final PackageIdentifier directory;
        private final boolean rulesOnly;

        @VisibleForTesting
        TargetsBelowDirectory(String originalPattern, PackageIdentifier directory, boolean rulesOnly) {
            super(originalPattern);
            this.directory = Preconditions.checkNotNull(directory);
            this.rulesOnly = rulesOnly;
        }

        @Override
        public <T, E extends Exception> void eval(TargetPatternResolver<T> resolver, InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass) throws TargetParsingException, E, InterruptedException, ProcessPackageDirectoryException {
            Preconditions.checkState(!excludedSubdirectories.contains(this.directory.getPackageFragment()), "Fully excluded target pattern %s should have already been filtered out (%s)", (Object)this, excludedSubdirectories);
            IgnoredPathFragmentsInScopeOrFilteringIgnorer ignoredIntersection = this.getAllIgnoredSubdirectoriesToExclude(ignoredSubdirectories);
            if (this.warnIfFiltered(ignoredIntersection, resolver)) {
                return;
            }
            resolver.findTargetsBeneathDirectory(this.directory.getRepository(), this.getOriginalPattern(), this.directory.getPackageFragment().getPathString(), this.rulesOnly, ignoredIntersection.ignoredPathFragments(), excludedSubdirectories, callback, exceptionClass);
        }

        @Override
        public <T, E extends Exception> ListenableFuture<Void> evalAsync(TargetPatternResolver<T> resolver, InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass, ListeningExecutorService executor) {
            IgnoredPathFragmentsInScopeOrFilteringIgnorer ignoredIntersection;
            Preconditions.checkState(!excludedSubdirectories.contains(this.directory.getPackageFragment()), "Fully excluded target pattern %s should have already been filtered out (%s)", (Object)this, excludedSubdirectories);
            try {
                ignoredIntersection = this.getAllIgnoredSubdirectoriesToExclude(ignoredSubdirectories);
            }
            catch (InterruptedException e) {
                return Futures.immediateCancelledFuture();
            }
            if (this.warnIfFiltered(ignoredIntersection, resolver)) {
                return Futures.immediateVoidFuture();
            }
            return resolver.findTargetsBeneathDirectoryAsync(this.directory.getRepository(), this.getOriginalPattern(), this.directory.getPackageFragment().getPathString(), this.rulesOnly, ignoredIntersection.ignoredPathFragments(), excludedSubdirectories, callback, exceptionClass, executor);
        }

        private boolean warnIfFiltered(IgnoredPathFragmentsInScopeOrFilteringIgnorer ignoredIntersection, TargetPatternResolver<?> resolver) {
            if (ignoredIntersection.wasFiltered()) {
                resolver.warn("Pattern '" + this.getOriginalPattern() + "' was filtered out by ignored directory '" + ignoredIntersection.filteringIgnorer().getPathString() + "'");
                return true;
            }
            return false;
        }

        public IgnoredPathFragmentsInScopeOrFilteringIgnorer getAllIgnoredSubdirectoriesToExclude(InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredPackagePrefixes) throws InterruptedException {
            ImmutableSet.Builder ignoredPathsBuilder = ImmutableSet.builderWithExpectedSize(0);
            for (PathFragment ignoredPackagePrefix : ignoredPackagePrefixes.get()) {
                if (this.containedIn(ignoredPackagePrefix)) {
                    return new IgnoredPathFragmentsInScopeOrFilteringIgnorer.FilteringIgnorer(ignoredPackagePrefix);
                }
                PackageIdentifier pkgIdForIgnoredDirectorPrefix = PackageIdentifier.create(this.directory.getRepository(), ignoredPackagePrefix);
                if (!this.containsAllTransitiveSubdirectories(pkgIdForIgnoredDirectorPrefix)) continue;
                ignoredPathsBuilder.add(ignoredPackagePrefix);
            }
            return IgnoredPathFragmentsInScopeOrFilteringIgnorer.IgnoredPathFragments.of((ImmutableSet<PathFragment>)ignoredPathsBuilder.build());
        }

        public boolean containedIn(PathFragment containingDirectory) {
            return this.directory.getPackageFragment().startsWith(containingDirectory);
        }

        public boolean containsAllTransitiveSubdirectories(PackageIdentifier containedDirectory) {
            return containedDirectory.getRepository().equals(this.directory.getRepository()) && containedDirectory.getPackageFragment().startsWith(this.directory.getPackageFragment());
        }

        public ContainsResult contains(TargetsBelowDirectory containedPattern) {
            if (this.containsAllTransitiveSubdirectories(containedPattern.directory)) {
                return !this.rulesOnly && containedPattern.rulesOnly ? ContainsResult.DIRECTORY_EXCLUSION_WOULD_BE_TOO_BROAD : ContainsResult.DIRECTORY_EXCLUSION_WOULD_BE_EXACT;
            }
            return ContainsResult.NOT_CONTAINED;
        }

        @Override
        public PackageIdentifier getDirectory() {
            return this.directory;
        }

        @Override
        public RepositoryName getRepository() {
            return this.directory.getRepository();
        }

        @Override
        public boolean getRulesOnly() {
            return this.rulesOnly;
        }

        @Override
        public Type getType() {
            return Type.TARGETS_BELOW_DIRECTORY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetsBelowDirectory)) {
                return false;
            }
            TargetsBelowDirectory that = (TargetsBelowDirectory)o;
            return this.rulesOnly == that.rulesOnly && this.getOriginalPattern().equals(that.getOriginalPattern()) && this.directory.equals(that.directory);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.getOriginalPattern(), this.directory, this.rulesOnly});
        }

        public String toString() {
            return this.toStringHelper().add("directory", this.directory).add("rulesOnly", this.rulesOnly).toString();
        }

        public static enum ContainsResult {
            DIRECTORY_EXCLUSION_WOULD_BE_EXACT,
            DIRECTORY_EXCLUSION_WOULD_BE_TOO_BROAD,
            NOT_CONTAINED;

        }

        public static abstract class IgnoredPathFragmentsInScopeOrFilteringIgnorer {
            public abstract boolean wasFiltered();

            public abstract ImmutableSet<PathFragment> ignoredPathFragments();

            public abstract PathFragment filteringIgnorer();

            private static class FilteringIgnorer
            extends IgnoredPathFragmentsInScopeOrFilteringIgnorer {
                private final PathFragment filteringIgnorer;

                FilteringIgnorer(PathFragment filteringIgnorer) {
                    this.filteringIgnorer = filteringIgnorer;
                }

                @Override
                public boolean wasFiltered() {
                    return true;
                }

                @Override
                public ImmutableSet<PathFragment> ignoredPathFragments() {
                    throw new UnsupportedOperationException("was filtered: " + this.filteringIgnorer);
                }

                @Override
                public PathFragment filteringIgnorer() {
                    return this.filteringIgnorer;
                }
            }

            private static class IgnoredPathFragments
            extends IgnoredPathFragmentsInScopeOrFilteringIgnorer {
                private static final IgnoredPathFragments EMPTYSET_IGNORED = new IgnoredPathFragments(ImmutableSet.of());
                private final ImmutableSet<PathFragment> ignoredPathFragments;

                private IgnoredPathFragments(ImmutableSet<PathFragment> ignoredPathFragments) {
                    this.ignoredPathFragments = ignoredPathFragments;
                }

                static IgnoredPathFragments of(ImmutableSet<PathFragment> ignoredPathFragments) {
                    if (ignoredPathFragments.isEmpty()) {
                        return EMPTYSET_IGNORED;
                    }
                    return new IgnoredPathFragments(ignoredPathFragments);
                }

                @Override
                public boolean wasFiltered() {
                    return false;
                }

                @Override
                public ImmutableSet<PathFragment> ignoredPathFragments() {
                    return this.ignoredPathFragments;
                }

                @Override
                public PathFragment filteringIgnorer() {
                    throw new UnsupportedOperationException("No filter: " + this.ignoredPathFragments);
                }
            }
        }
    }

    @VisibleForTesting
    static final class TargetsInPackage
    extends TargetPattern {
        private final PackageIdentifier packageIdentifier;
        private final String suffix;
        private final boolean wasOriginallyAbsolute;
        private final boolean rulesOnly;

        @VisibleForTesting
        TargetsInPackage(String originalPattern, PackageIdentifier packageIdentifier, String suffix, boolean wasOriginallyAbsolute, boolean rulesOnly) {
            super(originalPattern);
            this.packageIdentifier = packageIdentifier;
            this.suffix = Preconditions.checkNotNull(suffix);
            this.wasOriginallyAbsolute = wasOriginallyAbsolute;
            this.rulesOnly = rulesOnly;
        }

        @Override
        public <T, E extends Exception> void eval(TargetPatternResolver<T> resolver, InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass) throws TargetParsingException, E, InterruptedException, InconsistentFilesystemException {
            ResolvedTargets<T> targets = this.getWildcardConflict(resolver);
            if (targets != null) {
                callback.process(targets.getTargets());
                return;
            }
            callback.process(resolver.getTargetsInPackage(this.getOriginalPattern(), this.packageIdentifier, this.rulesOnly));
        }

        @Override
        public PackageIdentifier getDirectory() {
            return this.packageIdentifier;
        }

        @Override
        public RepositoryName getRepository() {
            return this.packageIdentifier.getRepository();
        }

        @Override
        public boolean getRulesOnly() {
            return this.rulesOnly;
        }

        @Override
        public Type getType() {
            return Type.TARGETS_IN_PACKAGE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetsInPackage)) {
                return false;
            }
            TargetsInPackage that = (TargetsInPackage)o;
            return this.wasOriginallyAbsolute == that.wasOriginallyAbsolute && this.rulesOnly == that.rulesOnly && this.getOriginalPattern().equals(that.getOriginalPattern()) && this.packageIdentifier.equals(that.packageIdentifier) && this.suffix.equals(that.suffix);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.getOriginalPattern(), this.packageIdentifier, this.suffix, this.wasOriginallyAbsolute, this.rulesOnly});
        }

        public String toString() {
            return this.toStringHelper().add("packageIdentifier", this.packageIdentifier).add("suffix", this.suffix).add("wasOriginallyAbsolute", this.wasOriginallyAbsolute).add("rulesOnly", this.rulesOnly).toString();
        }

        @Nullable
        private <T> ResolvedTargets<T> getWildcardConflict(TargetPatternResolver<T> resolver) throws InconsistentFilesystemException, InterruptedException {
            T target;
            Label label;
            if (!this.wasOriginallyAbsolute) {
                return null;
            }
            try {
                label = Label.create(this.packageIdentifier, this.suffix);
                target = resolver.getTargetOrNull(label);
            }
            catch (LabelSyntaxException e) {
                return null;
            }
            if (target != null) {
                resolver.warn(String.format("The target pattern '%s' is ambiguous: '%s' is both a wildcard, and the name of an existing %s; using the latter interpretation", this.getOriginalPattern(), ":" + this.suffix, resolver.getTargetKind(target)));
                try {
                    return resolver.getExplicitTarget(label);
                }
                catch (TargetParsingException e) {
                    throw new IllegalStateException("getTargetOrNull() returned non-null, so target should exist", e);
                }
            }
            return null;
        }
    }

    @VisibleForTesting
    static final class InterpretPathAsTarget
    extends TargetPattern {
        private final String path;

        @VisibleForTesting
        InterpretPathAsTarget(String originalPattern, String path) {
            super(originalPattern);
            this.path = InterpretPathAsTarget.normalize(Preconditions.checkNotNull(path));
        }

        @Override
        public <T, E extends Exception> void eval(TargetPatternResolver<T> resolver, InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass) throws TargetParsingException, E, InterruptedException, InconsistentFilesystemException {
            PackageIdentifier pathAsPackage = PackageIdentifier.createInMainRepo(this.path);
            if (!resolver.isPackage(pathAsPackage)) {
                List<String> pieces = SLASH_SPLITTER.splitToList(this.path);
                for (int i = pieces.size() - 1; i >= 0; --i) {
                    PackageIdentifier pkg = PackageIdentifier.createInMainRepo(SLASH_JOINER.join(pieces.subList(0, i)));
                    if (!resolver.isPackage(pkg)) continue;
                    String targetName = SLASH_JOINER.join(pieces.subList(i, pieces.size()));
                    callback.process(resolver.getExplicitTarget(TargetPattern.label(pkg, targetName)).getTargets());
                    return;
                }
                throw new TargetParsingException("couldn't determine target from filename '" + this.path + "'", FailureDetails.TargetPatterns.Code.CANNOT_DETERMINE_TARGET_FROM_FILENAME);
            }
            callback.process(resolver.getExplicitTarget(TargetPattern.label(pathAsPackage, pathAsPackage.getPackageFragment().getBaseName())).getTargets());
        }

        @Override
        public String getPathForPathAsTarget() {
            return this.path;
        }

        @Override
        public RepositoryName getRepository() {
            return RepositoryName.MAIN;
        }

        @Override
        public boolean getRulesOnly() {
            return false;
        }

        @Override
        public Type getType() {
            return Type.PATH_AS_TARGET;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InterpretPathAsTarget)) {
                return false;
            }
            InterpretPathAsTarget that = (InterpretPathAsTarget)o;
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.path});
        }

        public String toString() {
            return this.toStringHelper().add("path", this.path).toString();
        }
    }

    @VisibleForTesting
    static final class SingleTarget
    extends TargetPattern {
        private final Label target;

        @VisibleForTesting
        SingleTarget(String originalPattern, Label target) {
            super(originalPattern);
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public <T, E extends Exception> void eval(TargetPatternResolver<T> resolver, InterruptibleSupplier<ImmutableSet<PathFragment>> ignoredSubdirectories, ImmutableSet<PathFragment> excludedSubdirectories, BatchCallback<T, E> callback, Class<E> exceptionClass) throws TargetParsingException, E, InterruptedException {
            callback.process(resolver.getExplicitTarget(this.target).getTargets());
        }

        @Override
        public PackageIdentifier getDirectory() {
            return this.target.getPackageIdentifier();
        }

        @Override
        public RepositoryName getRepository() {
            return this.target.getRepository();
        }

        @Override
        public boolean getRulesOnly() {
            return false;
        }

        @Override
        public Label getSingleTargetLabel() {
            return this.target;
        }

        @Override
        public Type getType() {
            return Type.SINGLE_TARGET;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SingleTarget)) {
                return false;
            }
            SingleTarget that = (SingleTarget)o;
            return this.target.equals(that.target);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.target});
        }

        public String toString() {
            return this.toStringHelper().add("target", this.target).toString();
        }
    }
}

