/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.io.InconsistentFilesystemException;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.skyframe.DetailedException;
import com.google.devtools.build.lib.util.DetailedExitCode;

public class TargetParsingException
extends Exception
implements DetailedException {
    private final DetailedExitCode detailedExitCode;

    public TargetParsingException(String message, FailureDetails.TargetPatterns.Code code) {
        super(Preconditions.checkNotNull(message));
        this.detailedExitCode = DetailedExitCode.of(TargetParsingException.createFailureDetail(message, code));
    }

    public TargetParsingException(String message, Throwable cause, FailureDetails.TargetPatterns.Code code) {
        super(Preconditions.checkNotNull(message), cause);
        this.detailedExitCode = DetailedExitCode.of(TargetParsingException.createFailureDetail(message, code));
    }

    public TargetParsingException(String message, Throwable cause, DetailedExitCode detailedExitCode) {
        super(Preconditions.checkNotNull(message), cause);
        this.detailedExitCode = Preconditions.checkNotNull(detailedExitCode);
    }

    public TargetParsingException(String message, DetailedExitCode detailedExitCode) {
        super(Preconditions.checkNotNull(message));
        this.detailedExitCode = Preconditions.checkNotNull(detailedExitCode);
    }

    public TargetParsingException(InconsistentFilesystemException cause) {
        super(cause.getMessage(), cause);
        this.detailedExitCode = DetailedExitCode.of(FailureDetails.FailureDetail.newBuilder().setPackageLoading(FailureDetails.PackageLoading.newBuilder().setCode(FailureDetails.PackageLoading.Code.TRANSIENT_INCONSISTENT_FILESYSTEM_ERROR)).setMessage(this.getMessage()).build());
    }

    private static FailureDetails.FailureDetail createFailureDetail(String message, FailureDetails.TargetPatterns.Code code) {
        return FailureDetails.FailureDetail.newBuilder().setMessage(message).setTargetPatterns(FailureDetails.TargetPatterns.newBuilder().setCode(code).build()).build();
    }

    @Override
    public DetailedExitCode getDetailedExitCode() {
        return this.detailedExitCode;
    }
}

