/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ResolvedTargets<T> {
    private static final ResolvedTargets<?> FAILED_RESULT = new ResolvedTargets(ImmutableSet.of(), ImmutableSet.of(), true);
    private static final ResolvedTargets<?> EMPTY_RESULT = new ResolvedTargets(ImmutableSet.of(), ImmutableSet.of(), false);
    private final boolean hasError;
    private final ImmutableSet<T> targets;
    private final ImmutableSet<T> filteredTargets;

    public static <T> ResolvedTargets<T> failed() {
        return FAILED_RESULT;
    }

    public static <T> ResolvedTargets<T> empty() {
        return EMPTY_RESULT;
    }

    public static <T> ResolvedTargets<T> of(T target) {
        return new ResolvedTargets<T>(ImmutableSet.of(target), false);
    }

    public ResolvedTargets(Set<T> targets, Set<T> filteredTargets, boolean hasError) {
        this.targets = ImmutableSet.copyOf(targets);
        this.filteredTargets = ImmutableSet.copyOf(filteredTargets);
        this.hasError = hasError;
    }

    public ResolvedTargets(Set<T> targets, boolean hasError) {
        this.targets = ImmutableSet.copyOf(targets);
        this.filteredTargets = ImmutableSet.of();
        this.hasError = hasError;
    }

    public String toString() {
        return "ResolvedTargets(" + this.targets + ", filtered=" + this.filteredTargets + ", hasError=" + this.hasError + ")";
    }

    public boolean hasError() {
        return this.hasError;
    }

    public ImmutableSet<T> getTargets() {
        return this.targets;
    }

    public ImmutableSet<T> getFilteredTargets() {
        return this.filteredTargets;
    }

    public static <T> Builder<T> concurrentBuilder() {
        return new Builder(Sets.newConcurrentHashSet(), Sets.newConcurrentHashSet());
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private Set<T> targets;
        private Set<T> filteredTargets;
        private volatile boolean hasError = false;

        private Builder() {
            this(new LinkedHashSet(), new LinkedHashSet());
        }

        private Builder(Set<T> targets, Set<T> filteredTargets) {
            this.targets = targets;
            this.filteredTargets = filteredTargets;
        }

        public ResolvedTargets<T> build() {
            return new ResolvedTargets<T>(this.targets, this.filteredTargets, this.hasError);
        }

        @CanIgnoreReturnValue
        public Builder<T> merge(ResolvedTargets<T> other) {
            this.removeAll(other.filteredTargets);
            this.addAll(other.targets);
            if (other.hasError) {
                this.hasError = true;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> add(T target) {
            this.targets.add(target);
            this.filteredTargets.remove(target);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> addAll(Collection<T> targets) {
            this.targets.addAll(targets);
            this.filteredTargets.removeAll(targets);
            return this;
        }

        public void remove(T target) {
            this.targets.remove(target);
            this.filteredTargets.add(target);
        }

        @CanIgnoreReturnValue
        public Builder<T> removeAll(Collection<T> targets) {
            this.filteredTargets.addAll(targets);
            this.targets.removeAll(targets);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> filter(Predicate<T> predicate) {
            Set<T> oldTargets = this.targets;
            this.targets = Sets.newLinkedHashSet();
            for (T target : oldTargets) {
                if (predicate.apply(target)) {
                    this.add(target);
                    continue;
                }
                this.remove(target);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> setError() {
            this.hasError = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> mergeError(boolean hasError) {
            this.hasError |= hasError;
            return this;
        }

        public boolean isEmpty() {
            return this.targets.isEmpty();
        }
    }
}

