/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.devtools.build.lib.cmdline.LabelConstants;
import com.google.devtools.build.lib.cmdline.LabelParser;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.Pair;
import com.google.devtools.build.lib.util.StringCanonicalizer;
import com.google.devtools.build.lib.util.StringUtilities;
import com.google.devtools.build.lib.vfs.OsPathPolicy;
import com.google.devtools.build.lib.vfs.PathFragment;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;

public final class RepositoryName {
    @SerializationConstant
    public static final RepositoryName BAZEL_TOOLS = new RepositoryName("bazel_tools");
    @SerializationConstant
    public static final RepositoryName MAIN = new RepositoryName("");
    private static final Pattern VALID_REPO_NAME = Pattern.compile("|[\\w\\-.][\\w\\-.~]*");
    private static final Pattern VALID_USER_PROVIDED_NAME = Pattern.compile("[a-zA-Z][-.\\w]*$");
    public static final Pattern VALID_MODULE_NAME = Pattern.compile("[a-z]([a-z0-9._-]*[a-z0-9])?");
    private static final LoadingCache<String, RepositoryName> repositoryNameCache = Caffeine.newBuilder().weakValues().build(name -> {
        RepositoryName.validate(name);
        return new RepositoryName(StringCanonicalizer.intern(name));
    });
    private final String name;
    private final RepositoryName ownerRepoIfNotVisible;

    public static RepositoryName create(String name) throws LabelSyntaxException {
        if (name.isEmpty()) {
            return MAIN;
        }
        try {
            return repositoryNameCache.get(name);
        }
        catch (CompletionException e) {
            Throwables.propagateIfPossible(e.getCause(), LabelSyntaxException.class);
            throw e;
        }
    }

    public static RepositoryName createUnvalidated(String name) {
        if (name.isEmpty()) {
            return MAIN;
        }
        return repositoryNameCache.get(name);
    }

    @Nullable
    public static Pair<RepositoryName, PathFragment> fromPathFragment(PathFragment path, boolean siblingRepositoryLayout) {
        PathFragment prefix;
        if (!path.isMultiSegment()) {
            return null;
        }
        PathFragment pathFragment = prefix = siblingRepositoryLayout ? LabelConstants.EXPERIMENTAL_EXTERNAL_PATH_PREFIX : LabelConstants.EXTERNAL_PATH_PREFIX;
        if (!path.startsWith(prefix)) {
            return null;
        }
        try {
            RepositoryName repoName = RepositoryName.create(path.getSegment(1));
            PathFragment subPath = path.subFragment(2);
            return Pair.of(repoName, subPath);
        }
        catch (LabelSyntaxException e) {
            return null;
        }
    }

    private RepositoryName(String name, RepositoryName ownerRepoIfNotVisible) {
        this.name = name;
        this.ownerRepoIfNotVisible = ownerRepoIfNotVisible;
    }

    private RepositoryName(String name) {
        this(name, null);
    }

    static void validate(String name) throws LabelSyntaxException {
        if (name.isEmpty()) {
            return;
        }
        if (name.equals(".") || name.equals("..")) {
            throw LabelParser.syntaxErrorf("invalid repository name '@%s': repo names are not allowed to be '@%s'", name, name);
        }
        if (!VALID_REPO_NAME.matcher(name).matches()) {
            throw LabelParser.syntaxErrorf("invalid repository name '@%s': repo names may contain only A-Z, a-z, 0-9, '-', '_', '.' and '~' and must not start with '~'", StringUtilities.sanitizeControlChars(name));
        }
    }

    public static void validateUserProvidedRepoName(String name) throws EvalException {
        if (!VALID_USER_PROVIDED_NAME.matcher(name).matches()) {
            throw Starlark.errorf("invalid user-provided repo name '%s': valid names may contain only A-Z, a-z, 0-9, '-', '_', '.', and must start with a letter", StringUtilities.sanitizeControlChars(name));
        }
    }

    public String getName() {
        return this.name;
    }

    public RepositoryName toNonVisible(RepositoryName ownerRepo) {
        Preconditions.checkNotNull(ownerRepo);
        Preconditions.checkArgument(ownerRepo.isVisible());
        return new RepositoryName(this.name, ownerRepo);
    }

    public boolean isVisible() {
        return this.ownerRepoIfNotVisible == null;
    }

    public String getOwnerRepoDisplayString() {
        Preconditions.checkNotNull(this.ownerRepoIfNotVisible);
        if (this.ownerRepoIfNotVisible.isMain()) {
            return "main repository";
        }
        return String.format("repository '%s'", this.ownerRepoIfNotVisible.getNameWithAt());
    }

    public boolean isMain() {
        return this.equals(MAIN);
    }

    public String getNameWithAt() {
        if (!this.isVisible()) {
            return String.format("@[unknown repo '%s' requested from %s]", this.name, this.ownerRepoIfNotVisible.getNameWithAt());
        }
        return "@" + this.name;
    }

    public String getCanonicalForm() {
        return this.isMain() ? "" : this.getNameWithAt();
    }

    public String getDisplayForm(RepositoryMapping mainRepositoryMapping) {
        Preconditions.checkArgument(mainRepositoryMapping.ownerRepo() == null || mainRepositoryMapping.ownerRepo().isMain());
        if (this.isMain()) {
            return "";
        }
        if (!mainRepositoryMapping.usesStrictDeps()) {
            return this.getNameWithAt();
        }
        return mainRepositoryMapping.getInverse(this).map(apparentName -> "@" + apparentName).orElse("@" + this.getNameWithAt());
    }

    public PathFragment getExecPath(boolean siblingRepositoryLayout) {
        if (this.isMain()) {
            return PathFragment.EMPTY_FRAGMENT;
        }
        PathFragment prefix = siblingRepositoryLayout ? LabelConstants.EXPERIMENTAL_EXTERNAL_PATH_PREFIX : LabelConstants.EXTERNAL_PATH_PREFIX;
        return prefix.getRelative(this.getName());
    }

    public PathFragment getRunfilesPath() {
        return this.isMain() ? PathFragment.EMPTY_FRAGMENT : PathFragment.create("..").getRelative(this.getName());
    }

    public String toString() {
        return this.getNameWithAt();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RepositoryName)) {
            return false;
        }
        RepositoryName other = (RepositoryName)object;
        return OsPathPolicy.getFilePathOs().equals(this.name, other.name) && Objects.equals(this.ownerRepoIfNotVisible, other.ownerRepoIfNotVisible);
    }

    public int hashCode() {
        return Objects.hash(OsPathPolicy.getFilePathOs().hash(this.name), this.ownerRepoIfNotVisible);
    }
}

