/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.AutoValue_RepositoryMapping;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class RepositoryMapping {
    public static final RepositoryMapping ALWAYS_FALLBACK = RepositoryMapping.createAllowingFallback(ImmutableMap.of());

    public abstract ImmutableMap<String, RepositoryName> entries();

    @Nullable
    abstract RepositoryName ownerRepo();

    public static RepositoryMapping create(Map<String, RepositoryName> entries, RepositoryName ownerRepo) {
        return RepositoryMapping.createInternal(Preconditions.checkNotNull(entries), Preconditions.checkNotNull(ownerRepo));
    }

    public static RepositoryMapping createAllowingFallback(Map<String, RepositoryName> entries) {
        return RepositoryMapping.createInternal(Preconditions.checkNotNull(entries), null);
    }

    private static RepositoryMapping createInternal(Map<String, RepositoryName> entries, RepositoryName ownerRepo) {
        return new AutoValue_RepositoryMapping(ImmutableMap.copyOf(entries), ownerRepo);
    }

    public RepositoryMapping withAdditionalMappings(Map<String, RepositoryName> additionalMappings) {
        HashMap<String, RepositoryName> allMappings = new HashMap<String, RepositoryName>(additionalMappings);
        allMappings.putAll(this.entries());
        return RepositoryMapping.createInternal(allMappings, this.ownerRepo());
    }

    public RepositoryMapping withAdditionalMappings(RepositoryMapping additionalMappings) {
        return this.withAdditionalMappings(additionalMappings.entries());
    }

    public RepositoryName get(String preMappingName) {
        RepositoryName canonicalRepoName = this.entries().get(preMappingName);
        if (canonicalRepoName != null) {
            return canonicalRepoName;
        }
        if (this.ownerRepo() == null) {
            return RepositoryName.createUnvalidated(preMappingName);
        }
        return RepositoryName.createUnvalidated(preMappingName).toNonVisible(this.ownerRepo());
    }

    public boolean usesStrictDeps() {
        return this.ownerRepo() != null;
    }

    public Optional<String> getInverse(RepositoryName postMappingName) {
        return this.entries().entrySet().stream().filter(e -> ((RepositoryName)e.getValue()).equals(postMappingName)).map(Map.Entry::getKey).findFirst();
    }

    public RepositoryMapping composeWith(RepositoryMapping other) {
        Preconditions.checkArgument(!this.usesStrictDeps(), "only an allow-fallback mapping can be composed with other mappings");
        HashMap<String, RepositoryName> entries = new HashMap<String, RepositoryName>(other.entries());
        for (Map.Entry entry : this.entries().entrySet()) {
            RepositoryName mappedName = other.get(((RepositoryName)entry.getValue()).getName());
            entries.put((String)entry.getKey(), mappedName.isVisible() ? mappedName : (RepositoryName)entry.getValue());
        }
        return RepositoryMapping.createInternal(entries, null);
    }
}

