/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class PackageIdentifier_AutoCodec
implements ObjectCodec<PackageIdentifier> {
    private final long repository_offset;
    private final long pkgName_offset;

    PackageIdentifier_AutoCodec() {
        try {
            this.repository_offset = UnsafeProvider.unsafe().objectFieldOffset(PackageIdentifier.class.getDeclaredField("repository"));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        try {
            this.pkgName_offset = UnsafeProvider.unsafe().objectFieldOffset(PackageIdentifier.class.getDeclaredField("pkgName"));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void serialize(SerializationContext context, PackageIdentifier input, CodedOutputStream codedOut) throws SerializationException, IOException {
        RepositoryName unsafe_repository = (RepositoryName)UnsafeProvider.unsafe().getObject(input, this.repository_offset);
        context.serialize(unsafe_repository, codedOut);
        PathFragment unsafe_pkgName = (PathFragment)UnsafeProvider.unsafe().getObject(input, this.pkgName_offset);
        context.serialize(unsafe_pkgName, codedOut);
    }

    @Override
    public PackageIdentifier deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        RepositoryName repository_ = (RepositoryName)context.deserialize(codedIn);
        PathFragment pkgName_ = (PathFragment)context.deserialize(codedIn);
        return PackageIdentifier.create(repository_, pkgName_);
    }

    @Override
    public Class<PackageIdentifier> getEncodedClass() {
        return PackageIdentifier.class;
    }
}

