/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.devtools.build.lib.cmdline.LabelConstants;
import com.google.devtools.build.lib.cmdline.LabelParser;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.skyframe.SkyFunctions;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.util.HashCodes;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.skyframe.CPUHeavySkyKey;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.devtools.build.skyframe.SkyKey;
import javax.annotation.concurrent.Immutable;

@AutoCodec
@Immutable
public final class PackageIdentifier
implements CPUHeavySkyKey,
Comparable<PackageIdentifier> {
    private static final SkyKey.SkyKeyInterner<PackageIdentifier> interner = SkyKey.newInterner();
    public static final PackageIdentifier EMPTY_PACKAGE_ID = PackageIdentifier.createInMainRepo(PathFragment.EMPTY_FRAGMENT);
    private final RepositoryName repository;
    private final PathFragment pkgName;
    private final int hashCode;

    public static PackageIdentifier create(String repository, PathFragment pkgName) throws LabelSyntaxException {
        return PackageIdentifier.create(RepositoryName.create(repository), pkgName);
    }

    @AutoCodec.Instantiator
    public static PackageIdentifier create(RepositoryName repository, PathFragment pkgName) {
        return interner.intern(new PackageIdentifier(repository, pkgName));
    }

    public static PackageIdentifier createUnchecked(String repository, String pkgName) {
        return PackageIdentifier.create(RepositoryName.createUnvalidated(repository), PathFragment.create(pkgName));
    }

    public static PackageIdentifier createInMainRepo(String name) {
        return PackageIdentifier.createInMainRepo(PathFragment.create(name));
    }

    public static PackageIdentifier createInMainRepo(PathFragment name) {
        return PackageIdentifier.create(RepositoryName.MAIN, name);
    }

    public static PackageIdentifier discoverFromExecPath(PathFragment execPath, boolean forFiles, boolean siblingRepositoryLayout) {
        PathFragment prefix;
        Preconditions.checkArgument(!execPath.isAbsolute(), execPath);
        PathFragment tofind = forFiles ? Preconditions.checkNotNull(execPath.getParentDirectory(), "Must pass in files, not root directory") : execPath;
        PathFragment pathFragment = prefix = siblingRepositoryLayout ? LabelConstants.EXPERIMENTAL_EXTERNAL_PATH_PREFIX : LabelConstants.EXTERNAL_PATH_PREFIX;
        if (tofind.startsWith(prefix)) {
            RepositoryName repository = RepositoryName.createUnvalidated(tofind.getSegment(1));
            return PackageIdentifier.create(repository, tofind.subFragment(2));
        }
        return PackageIdentifier.createInMainRepo(tofind);
    }

    private PackageIdentifier(RepositoryName repository, PathFragment pkgName) {
        this.repository = Preconditions.checkNotNull(repository);
        this.pkgName = Preconditions.checkNotNull(pkgName);
        this.hashCode = HashCodes.hashObjects(repository, pkgName);
    }

    public static PackageIdentifier parse(String input) throws LabelSyntaxException {
        if (input.contains(":")) {
            throw LabelParser.syntaxErrorf("invalid package identifier '%s': contains ':'", input);
        }
        LabelParser.Parts parts = LabelParser.Parts.parse(input + ":dummy_target");
        RepositoryName repoName = parts.repo() == null ? RepositoryName.MAIN : RepositoryName.createUnvalidated(parts.repo());
        return PackageIdentifier.create(repoName, PathFragment.create(parts.pkg()));
    }

    public RepositoryName getRepository() {
        return this.repository;
    }

    public PathFragment getPackageFragment() {
        return this.pkgName;
    }

    public PathFragment getSourceRoot() {
        return this.pkgName;
    }

    public PathFragment getPackagePath(boolean siblingRepositoryLayout) {
        return this.repository.isMain() || siblingRepositoryLayout ? this.pkgName : LabelConstants.EXTERNAL_PATH_PREFIX.getRelative(this.repository.getName()).getRelative(this.pkgName);
    }

    public PathFragment getExecPath(boolean siblingRepositoryLayout) {
        return this.repository.getExecPath(siblingRepositoryLayout).getRelative(this.pkgName);
    }

    public PathFragment getRunfilesPath() {
        return this.repository.getRunfilesPath().getRelative(this.pkgName);
    }

    public String getCanonicalForm() {
        return this.repository.getCanonicalForm() + "//" + this.pkgName;
    }

    String getUnambiguousCanonicalForm() {
        return String.format("@%s//%s", this.repository.getNameWithAt(), this.pkgName);
    }

    public String getDisplayForm(RepositoryMapping mainRepositoryMapping) {
        return String.format("%s//%s", this.repository.getDisplayForm(mainRepositoryMapping), this.pkgName);
    }

    @Override
    public SkyFunctionName functionName() {
        return SkyFunctions.PACKAGE;
    }

    @Override
    public SkyKey.SkyKeyInterner<?> getSkyKeyInterner() {
        return interner;
    }

    public String toString() {
        if (this.repository.isMain()) {
            return this.pkgName.getPathString();
        }
        return this.getCanonicalForm();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PackageIdentifier)) {
            return false;
        }
        PackageIdentifier that = (PackageIdentifier)object;
        return this.hashCode == that.hashCode && this.pkgName.equals(that.pkgName) && this.repository.equals(that.repository);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(PackageIdentifier that) {
        if (this == that) {
            return 0;
        }
        if (this.repository == that.repository) {
            return this.pkgName.compareTo(that.pkgName);
        }
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.repository.getName()), (Comparable<?>)((Object)that.repository.getName())).compare(this.pkgName, that.pkgName).result();
    }
}

