/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import java.util.Objects;
import javax.annotation.Nullable;

public final class LabelValidator {
    private static final CharMatcher PUNCTUATION_REQUIRING_QUOTING = CharMatcher.anyOf(" \"#$&'()*+,;<=>?[]{|}~");
    private static final CharMatcher PUNCTUATION_NOT_REQUIRING_QUOTING = CharMatcher.anyOf("!%-@^_`");
    private static final CharMatcher ALLOWED_CHARACTERS_IN_PACKAGE_NAME = CharMatcher.inRange('0', '9').or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.anyOf(" !\"#$%&'()*+,-./;<=>?@[]^_`{|}~")).precomputed();
    private static final CharMatcher ALWAYS_ALLOWED_TARGET_CHARACTERS = CharMatcher.javaLetterOrDigit().or(PUNCTUATION_REQUIRING_QUOTING).or(PUNCTUATION_NOT_REQUIRING_QUOTING).or(CharMatcher.inRange('\u0080', '\u00ff')).precomputed();
    @VisibleForTesting
    static final String PACKAGE_NAME_ERROR = "package names may contain A-Z, a-z, 0-9, or any of ' !\"#$%&'()*+,-./;<=>?[]^_`{|}~' (most 7-bit ascii characters except 0-31, 127, ':', or '\\')";
    @VisibleForTesting
    static final String PACKAGE_NAME_DOT_ERROR = "package name component contains only '.' characters";

    @Nullable
    public static String validatePackageName(String packageName) {
        int len = packageName.length();
        if (len == 0) {
            return null;
        }
        if (packageName.charAt(0) == '/') {
            return "package names may not start with '/'";
        }
        if (!ALLOWED_CHARACTERS_IN_PACKAGE_NAME.matchesAllOf(packageName)) {
            return PACKAGE_NAME_ERROR;
        }
        if (packageName.charAt(packageName.length() - 1) == '/') {
            return "package names may not end with '/'";
        }
        boolean nonDot = false;
        boolean lastSlash = true;
        for (int i = len - 1; i >= -1; --i) {
            int c;
            int n = c = i >= 0 ? (int)packageName.charAt(i) : 47;
            if (c == 47) {
                if (lastSlash) {
                    return "package names may not contain '//' path separators";
                }
                if (!nonDot) {
                    return PACKAGE_NAME_DOT_ERROR;
                }
                nonDot = false;
                lastSlash = true;
                continue;
            }
            if (c != 46) {
                nonDot = true;
            }
            lastSlash = false;
        }
        return null;
    }

    @Nullable
    public static String validateTargetName(String targetName) {
        int len = targetName.length();
        if (len == 0) {
            return "empty target name";
        }
        char c = targetName.charAt(0);
        if (c == '/') {
            return "target names may not start with '/'";
        }
        if (c == '.') {
            if (targetName.startsWith("../") || targetName.equals("..")) {
                return "target names may not contain up-level references '..'";
            }
            if (targetName.equals(".")) {
                return null;
            }
            if (targetName.startsWith("./")) {
                return "target names may not contain '.' as a path segment";
            }
        }
        if (targetName.endsWith("\r")) {
            return "target names may not end with carriage returns (perhaps the input source is CRLF-terminated)";
        }
        for (int ii = 0; ii < len; ++ii) {
            c = targetName.charAt(ii);
            if (ALWAYS_ALLOWED_TARGET_CHARACTERS.matches(c) || c == '.') continue;
            if (c == '/') {
                if (LabelValidator.stringRegionMatch(targetName, "/../", ii)) {
                    return "target names may not contain up-level references '..'";
                }
                if (LabelValidator.stringRegionMatch(targetName, "/./", ii)) {
                    return "target names may not contain '.' as a path segment";
                }
                if (!LabelValidator.stringRegionMatch(targetName, "//", ii)) continue;
                return "target names may not contain '//' path separators";
            }
            if (c <= '\u001f' || c == '\u007f') {
                return "target names may not contain non-printable characters: '" + String.format("\\x%02X", c) + "'";
            }
            return "target names may not contain '" + c + "'";
        }
        if (c == '.') {
            if (targetName.endsWith("/..")) {
                return "target names may not contain up-level references '..'";
            }
            if (targetName.endsWith("/.")) {
                return null;
            }
        }
        if (c == '/') {
            return "target names may not end with '/'";
        }
        return null;
    }

    private static boolean stringRegionMatch(String fullString, String possibleMatch, int offset) {
        return fullString.regionMatches(offset, possibleMatch, 0, possibleMatch.length());
    }

    public static PackageAndTarget validateAbsoluteLabel(String absName) throws BadLabelException {
        PackageAndTarget result = LabelValidator.parseAbsoluteLabel(absName);
        String packageName = result.getPackageName();
        String targetName = result.getTargetName();
        Object error = LabelValidator.validatePackageName(packageName);
        if (error != null) {
            error = "invalid package name '" + packageName + "': " + (String)error;
            if (packageName.endsWith("/" + targetName)) {
                error = (String)error + " (perhaps you meant \":" + targetName + "\"?)";
            }
            throw new BadLabelException((String)error);
        }
        error = LabelValidator.validateTargetName(targetName);
        if (error != null) {
            error = "invalid target name '" + targetName + "': " + (String)error;
            throw new BadLabelException((String)error);
        }
        return result;
    }

    public static boolean isAbsolute(String label) {
        return label.startsWith("//") || label.startsWith("@");
    }

    public static PackageAndTarget parseAbsoluteLabel(String absName) throws BadLabelException {
        int colonIndex;
        if (!LabelValidator.isAbsolute(absName)) {
            throw new BadLabelException("invalid label: " + absName);
        }
        if (absName.startsWith("@")) {
            int endOfRepo = absName.indexOf("//");
            if (endOfRepo < 0) {
                return new PackageAndTarget("", absName.substring(1));
            }
            absName = absName.substring(endOfRepo);
        }
        int splitAt = (colonIndex = absName.indexOf(58)) >= 0 ? colonIndex : absName.length();
        String packageName = absName.substring("//".length(), splitAt);
        String suffix = absName.substring(splitAt);
        String targetName = suffix.isEmpty() ? packageName.substring(packageName.lastIndexOf(47) + 1) : suffix.substring(1);
        return new PackageAndTarget(packageName, targetName);
    }

    public static class BadLabelException
    extends Exception {
        public BadLabelException(String msg) {
            super(msg);
        }
    }

    public static class PackageAndTarget {
        private final String packageName;
        private final String targetName;

        public PackageAndTarget(String packageName, String targetName) {
            this.packageName = packageName;
            this.targetName = targetName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String toString() {
            return "//" + this.packageName + ":" + this.targetName;
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.targetName);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            PackageAndTarget otherTarget = (PackageAndTarget)o;
            return Objects.equals(otherTarget.targetName, this.targetName) && Objects.equals(otherTarget.packageName, this.packageName);
        }
    }
}

