/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.cmdline.AutoValue_LabelParser_Parts;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.LabelValidator;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.util.StringUtilities;
import com.google.errorprone.annotations.FormatMethod;
import javax.annotation.Nullable;

final class LabelParser {
    private LabelParser() {
    }

    @FormatMethod
    static LabelSyntaxException syntaxErrorf(String format, Object ... args) {
        return new LabelSyntaxException(StringUtilities.sanitizeControlChars(String.format(format, args)));
    }

    private static String perhapsYouMeantMessage(String pkg, String target) {
        return pkg.endsWith("/" + target) ? " (perhaps you meant \":" + target + "\"?)" : "";
    }

    static String validateAndProcessTargetName(String pkg, String target, boolean pkgEndsWithTripleDots) throws LabelSyntaxException {
        if (pkgEndsWithTripleDots && target.isEmpty()) {
            return target;
        }
        String targetError = LabelValidator.validateTargetName(target);
        if (targetError != null) {
            throw LabelParser.syntaxErrorf("invalid target name '%s': %s%s", target, targetError, LabelParser.perhapsYouMeantMessage(pkg, target));
        }
        if (target.endsWith("/.")) {
            return target.substring(0, target.length() - 2);
        }
        return target;
    }

    @AutoValue
    static abstract class Parts {
        Parts() {
        }

        @Nullable
        abstract String repo();

        abstract boolean repoIsCanonical();

        abstract boolean pkgIsAbsolute();

        abstract String pkg();

        abstract boolean pkgEndsWithTripleDots();

        abstract String target();

        abstract String raw();

        @VisibleForTesting
        static Parts validateAndCreate(@Nullable String repo, boolean repoIsCanonical, boolean pkgIsAbsolute, String pkg, boolean pkgEndsWithTripleDots, String target, String raw) throws LabelSyntaxException {
            Parts.validateRepoName(repo);
            Parts.validatePackageName(pkg, target);
            return new AutoValue_LabelParser_Parts(repo, repoIsCanonical, pkgIsAbsolute, pkg, pkgEndsWithTripleDots, LabelParser.validateAndProcessTargetName(pkg, target, pkgEndsWithTripleDots), raw);
        }

        static Parts parse(String rawLabel) throws LabelSyntaxException {
            String target;
            String pkg;
            boolean pkgEndsWithTripleDots;
            boolean pkgIsAbsolute;
            int startOfPackage;
            String repo;
            boolean repoIsCanonical = rawLabel.startsWith("@@");
            int doubleSlashIndex = rawLabel.indexOf("//");
            if (rawLabel.startsWith("@")) {
                if (doubleSlashIndex < 0) {
                    String repo2 = rawLabel.substring(repoIsCanonical ? 2 : 1);
                    return Parts.validateAndCreate(repo2, repoIsCanonical, true, "", false, repo2, rawLabel);
                }
                repo = rawLabel.substring(repoIsCanonical ? 2 : 1, doubleSlashIndex);
                startOfPackage = doubleSlashIndex + 2;
                pkgIsAbsolute = true;
            } else {
                pkgIsAbsolute = doubleSlashIndex == 0;
                startOfPackage = doubleSlashIndex == 0 ? 2 : 0;
                repo = null;
            }
            int colonIndex = rawLabel.indexOf(58, startOfPackage);
            String rawPkg = rawLabel.substring(startOfPackage, colonIndex >= 0 ? colonIndex : rawLabel.length());
            boolean bl = pkgEndsWithTripleDots = rawPkg.endsWith("/...") || rawPkg.equals("...");
            if (colonIndex < 0 && pkgEndsWithTripleDots) {
                pkg = Parts.stripTrailingTripleDots(rawPkg);
                target = "";
            } else if (colonIndex < 0 && !pkgIsAbsolute) {
                pkg = "";
                target = rawLabel.substring(startOfPackage);
            } else {
                pkg = Parts.stripTrailingTripleDots(rawPkg);
                target = colonIndex >= 0 ? rawLabel.substring(colonIndex + 1) : pkg.substring(pkg.lastIndexOf(47) + 1);
            }
            return Parts.validateAndCreate(repo, repoIsCanonical, pkgIsAbsolute, pkg, pkgEndsWithTripleDots, target, rawLabel);
        }

        private static String stripTrailingTripleDots(String pkg) {
            if (pkg.endsWith("/...")) {
                return pkg.substring(0, pkg.length() - 4);
            }
            if (pkg.equals("...")) {
                return "";
            }
            return pkg;
        }

        private static void validateRepoName(@Nullable String repo) throws LabelSyntaxException {
            if (repo != null) {
                RepositoryName.validate(repo);
            }
        }

        private static void validatePackageName(String pkg, String target) throws LabelSyntaxException {
            String pkgError = LabelValidator.validatePackageName(pkg);
            if (pkgError != null) {
                throw LabelParser.syntaxErrorf("invalid package name '%s': %s%s", pkg, pkgError, LabelParser.perhapsYouMeantMessage(pkg, target));
            }
        }

        void checkPkgIsAbsolute() throws LabelSyntaxException {
            if (!this.pkgIsAbsolute()) {
                throw LabelParser.syntaxErrorf("invalid label '%s': absolute label must begin with '@' or '//'", this.raw());
            }
        }

        void checkPkgDoesNotEndWithTripleDots() throws LabelSyntaxException {
            if (this.pkgEndsWithTripleDots()) {
                throw LabelParser.syntaxErrorf("invalid label '%s': package name cannot contain '...'", this.raw());
            }
        }
    }
}

