/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.util.concurrent.Striped;
import com.google.devtools.build.lib.actions.CommandLineItem;
import com.google.devtools.build.lib.cmdline.AutoValue_Label_PackageContextImpl;
import com.google.devtools.build.lib.cmdline.AutoValue_Label_RepoContextImpl;
import com.google.devtools.build.lib.cmdline.BazelModuleContext;
import com.google.devtools.build.lib.cmdline.LabelConstants;
import com.google.devtools.build.lib.cmdline.LabelParser;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.PackageIdentifier;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.devtools.build.lib.concurrent.PooledInterner;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.devtools.build.skyframe.SkyKey;
import com.google.devtools.build.skyframe.UsePooledLabelInterningFlag;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="Label", category="BUILTIN", doc="A BUILD target identifier.")
@AutoCodec
public final class Label
implements Comparable<Label>,
StarlarkValue,
SkyKey,
CommandLineItem {
    private static final ImmutableSet<String> ABSOLUTE_PACKAGE_NAMES = ImmutableSet.of("conditions", "visibility", LabelConstants.EXTERNAL_PACKAGE_NAME.getPathString());
    private static final String PKG_VISIBILITY_NAME = "__pkg__";
    private static final String SUBPACKAGES_VISIBILITY_NAME = "__subpackages__";
    public static final SkyFunctionName TRANSITIVE_TRAVERSAL = SkyFunctionName.createHermetic("TRANSITIVE_TRAVERSAL");
    @Nullable
    private static final LabelInterner pooledInterner = UsePooledLabelInterningFlag.usePooledLabelInterningFlag() ? new LabelInterner() : null;
    private static final Interner<Label> interner = pooledInterner != null ? pooledInterner : BlazeInterners.newWeakInterner();
    private final PackageIdentifier packageIdentifier;
    private final String name;

    @Nullable
    public static LabelInterner getLabelInterner() {
        return pooledInterner;
    }

    public static Label parseCanonical(String raw) throws LabelSyntaxException {
        LabelParser.Parts parts = LabelParser.Parts.parse(raw);
        parts.checkPkgDoesNotEndWithTripleDots();
        parts.checkPkgIsAbsolute();
        RepositoryName repoName = parts.repo() == null ? RepositoryName.MAIN : RepositoryName.createUnvalidated(parts.repo());
        return Label.createUnvalidated(PackageIdentifier.create(repoName, PathFragment.create(parts.pkg())), parts.target());
    }

    public static Label parseCanonicalUnchecked(String raw) {
        try {
            return Label.parseCanonical(raw);
        }
        catch (LabelSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static RepositoryName computeRepoNameWithRepoContext(LabelParser.Parts parts, RepoContext repoContext) {
        if (parts.repo() == null) {
            return ABSOLUTE_PACKAGE_NAMES.contains(parts.pkg()) ? RepositoryName.MAIN : repoContext.currentRepo();
        }
        if (parts.repoIsCanonical()) {
            return RepositoryName.createUnvalidated(parts.repo());
        }
        return repoContext.repoMapping().get(parts.repo());
    }

    public static Label parseWithRepoContext(String raw, RepoContext repoContext) throws LabelSyntaxException {
        LabelParser.Parts parts = LabelParser.Parts.parse(raw);
        parts.checkPkgDoesNotEndWithTripleDots();
        parts.checkPkgIsAbsolute();
        RepositoryName repoName = Label.computeRepoNameWithRepoContext(parts, repoContext);
        return Label.createUnvalidated(PackageIdentifier.create(repoName, PathFragment.create(parts.pkg())), parts.target());
    }

    public static Label parseWithPackageContext(String raw, PackageContext packageContext) throws LabelSyntaxException {
        LabelParser.Parts parts = LabelParser.Parts.parse(raw);
        parts.checkPkgDoesNotEndWithTripleDots();
        if (!parts.pkg().isEmpty()) {
            parts.checkPkgIsAbsolute();
        }
        RepositoryName repoName = Label.computeRepoNameWithRepoContext(parts, packageContext);
        PathFragment pkgFragment = parts.pkgIsAbsolute() ? PathFragment.create(parts.pkg()) : packageContext.packageFragment();
        return Label.createUnvalidated(PackageIdentifier.create(repoName, pkgFragment), parts.target());
    }

    public static Label create(String packageName, String targetName) throws LabelSyntaxException {
        return Label.createUnvalidated(PackageIdentifier.parse(packageName), LabelParser.validateAndProcessTargetName(packageName, targetName, false));
    }

    public static Label create(PackageIdentifier packageId, String targetName) throws LabelSyntaxException {
        return Label.createUnvalidated(packageId, LabelParser.validateAndProcessTargetName(packageId.getPackageFragment().getPathString(), targetName, false));
    }

    @AutoCodec.Instantiator
    public static Label createUnvalidated(PackageIdentifier packageIdentifier, String name) {
        String internedName = name;
        if (internedName.equals(PKG_VISIBILITY_NAME)) {
            internedName = PKG_VISIBILITY_NAME;
        } else if (internedName.equals(SUBPACKAGES_VISIBILITY_NAME)) {
            internedName = SUBPACKAGES_VISIBILITY_NAME;
        }
        return interner.intern(new Label(packageIdentifier, internedName));
    }

    private Label(PackageIdentifier packageIdentifier, String name) {
        Preconditions.checkNotNull(packageIdentifier);
        Preconditions.checkNotNull(name);
        this.packageIdentifier = packageIdentifier;
        this.name = name;
    }

    public PackageIdentifier getPackageIdentifier() {
        return this.packageIdentifier;
    }

    public RepositoryName getRepository() {
        return this.packageIdentifier.getRepository();
    }

    @StarlarkMethod(name="package", structField=true, doc="The package part of this label. For instance:<br><pre class=language-python>Label(\"//pkg/foo:abc\").package == \"pkg/foo\"</pre>")
    public String getPackageName() {
        return this.packageIdentifier.getPackageFragment().getPathString();
    }

    @StarlarkMethod(name="workspace_root", structField=true, doc="Returns the execution root for the workspace of this label, relative to the execroot. For instance:<br><pre class=language-python>Label(\"@repo//pkg/foo:abc\").workspace_root == \"external/repo\"</pre>", useStarlarkSemantics=true)
    @Deprecated
    public String getWorkspaceRootForStarlarkOnly(StarlarkSemantics semantics) throws EvalException {
        this.checkRepoVisibilityForStarlark("workspace_root");
        return this.packageIdentifier.getRepository().getExecPath(semantics.getBool("-experimental_sibling_repository_layout")).toString();
    }

    public PathFragment getPackageFragment() {
        return this.packageIdentifier.getPackageFragment();
    }

    public PathFragment toPathFragment() {
        Preconditions.checkArgument(!this.name.equals("."));
        return this.packageIdentifier.getPackageFragment().getRelative(this.name);
    }

    @StarlarkMethod(name="name", structField=true, doc="The name of this label within the package. For instance:<br><pre class=language-python>Label(\"//pkg/foo:abc\").name == \"abc\"</pre>")
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getCanonicalForm();
    }

    public String getCanonicalForm() {
        return this.packageIdentifier.getCanonicalForm() + ":" + this.name;
    }

    public String getUnambiguousCanonicalForm() {
        return this.packageIdentifier.getUnambiguousCanonicalForm() + ":" + this.name;
    }

    public String getDisplayForm(RepositoryMapping mainRepositoryMapping) {
        return this.packageIdentifier.getDisplayForm(mainRepositoryMapping) + ":" + this.name;
    }

    public String getShorthandDisplayForm(RepositoryMapping mainRepositoryMapping) {
        String repositoryDisplayForm;
        if (this.getPackageFragment().getBaseName().equals(this.name)) {
            return this.packageIdentifier.getDisplayForm(mainRepositoryMapping);
        }
        if (this.getPackageFragment().getBaseName().isEmpty() && ((repositoryDisplayForm = this.getPackageIdentifier().getRepository().getDisplayForm(mainRepositoryMapping)).equals("@" + this.name) || repositoryDisplayForm.equals("@@" + this.name))) {
            return repositoryDisplayForm;
        }
        return this.getDisplayForm(mainRepositoryMapping);
    }

    @StarlarkMethod(name="workspace_name", structField=true, doc="The repository part of this label. For instance, <pre class=language-python>Label(\"@foo//bar:baz\").workspace_name == \"foo\"</pre>")
    public String getWorkspaceName() throws EvalException {
        this.checkRepoVisibilityForStarlark("workspace_name");
        return this.packageIdentifier.getRepository().getName();
    }

    public String toShorthandString() {
        if (!this.getPackageFragment().getBaseName().equals(this.name)) {
            return this.toString();
        }
        String repository = this.packageIdentifier.getRepository().isMain() ? "" : this.packageIdentifier.getRepository().getNameWithAt();
        return repository + "//" + this.getPackageFragment();
    }

    public Label getLocalTargetLabel(String targetName) throws LabelSyntaxException {
        return Label.create(this.packageIdentifier, targetName);
    }

    @StarlarkMethod(name="relative", doc="Resolves a label that is either absolute (starts with <code>//</code>) or relative to the current package. If this label is in a remote repository, the argument will be resolved relative to that repository. If the argument contains a repository name, the current label is ignored and the argument is returned as-is, except that the repository name is rewritten if it is in the current repository mapping. Reserved labels will also be returned as-is.<br>For example:<br><pre class=language-python>\nLabel(\"//foo/bar:baz\").relative(\":quux\") == Label(\"//foo/bar:quux\")\nLabel(\"//foo/bar:baz\").relative(\"//wiz:quux\") == Label(\"//wiz:quux\")\nLabel(\"@repo//foo/bar:baz\").relative(\"//wiz:quux\") == Label(\"@repo//wiz:quux\")\nLabel(\"@repo//foo/bar:baz\").relative(\"//visibility:public\") == Label(\"//visibility:public\")\nLabel(\"@repo//foo/bar:baz\").relative(\"@other//wiz:quux\") == Label(\"@other//wiz:quux\")\n</pre><p>If the repository mapping passed in is <code>{'@other' : '@remapped'}</code>, then the following remapping will take place:<br><pre class=language-python>\nLabel(\"@repo//foo/bar:baz\").relative(\"@other//wiz:quux\") == Label(\"@remapped//wiz:quux\")\n</pre>", parameters={@Param(name="relName", doc="The label that will be resolved relative to this one.")}, useStarlarkThread=true)
    public Label getRelative(String relName, StarlarkThread thread) throws LabelSyntaxException {
        return Label.parseWithPackageContext(relName, PackageContext.of(this.packageIdentifier, BazelModuleContext.of(Module.ofInnermostEnclosingStarlarkFunction(thread)).repoMapping()));
    }

    @Override
    public SkyFunctionName functionName() {
        return TRANSITIVE_TRAVERSAL;
    }

    public int hashCode() {
        return Label.hashCode(this.name, this.packageIdentifier);
    }

    private static int hashCode(Object obj1, Object obj2) {
        int result = 31 + (obj1 == null ? 0 : obj1.hashCode());
        return 31 * result + (obj2 == null ? 0 : obj2.hashCode());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Label)) {
            return false;
        }
        Label otherLabel = (Label)other;
        return this.packageIdentifier.equals(otherLabel.packageIdentifier) && this.name.equals(otherLabel.name);
    }

    @Override
    public int compareTo(Label other) {
        if (this == other) {
            return 0;
        }
        return ComparisonChain.start().compare(this.packageIdentifier, other.packageIdentifier).compare((Comparable<?>)((Object)this.name), (Comparable<?>)((Object)other.name)).result();
    }

    public static String print(@Nullable Label label) {
        return label == null ? "(unknown)" : label.toString();
    }

    public static PathFragment getContainingDirectory(Label label) {
        PathFragment pkg = label.getPackageFragment();
        String name = label.name;
        if (name.equals(".")) {
            return pkg;
        }
        if (PathFragment.isNormalizedRelativePath(name) && !PathFragment.containsSeparator(name)) {
            return pkg;
        }
        return pkg.getRelative(name).getParentDirectory();
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public void repr(Printer printer) {
        printer.append("Label(");
        printer.repr(this.getCanonicalForm());
        printer.append(")");
    }

    @Override
    public void str(Printer printer, StarlarkSemantics semantics) {
        if (this.getRepository().isMain() && !semantics.getBool("+incompatible_unambiguous_label_stringification")) {
            printer.append(this.getCanonicalForm());
            return;
        }
        if (semantics.getBool("-enable_bzlmod")) {
            printer.append(this.getUnambiguousCanonicalForm());
            return;
        }
        printer.append(String.format("@%s//%s:%s", this.packageIdentifier.getRepository().getName(), this.packageIdentifier.getPackageFragment(), this.name));
    }

    @Override
    public String expandToCommandLine() {
        return this.getCanonicalForm();
    }

    private void checkRepoVisibilityForStarlark(String method) throws EvalException {
        if (!this.getRepository().isVisible()) {
            throw Starlark.errorf("'%s' is not allowed on invalid Label %s", method, this);
        }
    }

    public static final class LabelInterner
    extends PooledInterner<Label> {
        @Nullable
        static PooledInterner.Pool<Label> globalPool = null;
        private final Striped<ReadWriteLock> interningLocks = Striped.readWriteLock(BlazeInterners.concurrencyLevel());

        public static void setGlobalPool(PooledInterner.Pool<Label> pool) {
            globalPool = pool;
        }

        public Lock getLockForLabelLookup(Label label) {
            return this.interningLocks.get(label.getPackageIdentifier()).readLock();
        }

        public Lock getLockForLabelTransferToPool(PackageIdentifier packageIdentifier) {
            return this.interningLocks.get(packageIdentifier).writeLock();
        }

        @Override
        protected PooledInterner.Pool<Label> getPool() {
            return globalPool;
        }
    }

    @AutoValue
    static abstract class PackageContextImpl
    implements PackageContext {
        PackageContextImpl() {
        }
    }

    public static interface PackageContext
    extends RepoContext {
        public static PackageContext of(PackageIdentifier currentPackage, RepositoryMapping repoMapping) {
            return new AutoValue_Label_PackageContextImpl(currentPackage.getRepository(), repoMapping, currentPackage.getPackageFragment());
        }

        public PathFragment packageFragment();

        default public PackageIdentifier packageIdentifier() {
            return PackageIdentifier.create(this.currentRepo(), this.packageFragment());
        }
    }

    @AutoValue
    static abstract class RepoContextImpl
    implements RepoContext {
        RepoContextImpl() {
        }
    }

    public static interface RepoContext {
        public static RepoContext of(RepositoryName currentRepo, RepositoryMapping repoMapping) {
            return new AutoValue_Label_RepoContextImpl(currentRepo, repoMapping);
        }

        public RepositoryName currentRepo();

        public RepositoryMapping repoMapping();
    }
}

