/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.cmdline;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.AutoValue_BazelModuleContext;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import net.starlark.java.eval.Module;

@AutoValue
public abstract class BazelModuleContext {
    public abstract Label label();

    public abstract RepositoryMapping repoMapping();

    public abstract String filename();

    public abstract ImmutableMap<String, Module> loads();

    @AutoValue.CopyAnnotations
    public abstract byte[] bzlTransitiveDigest();

    public final String toString() {
        return this.label().toString();
    }

    public static BazelModuleContext of(Module m4) {
        return (BazelModuleContext)m4.getClientData();
    }

    public static BazelModuleContext create(Label label, RepositoryMapping repoMapping, String filename, ImmutableMap<String, Module> loads, byte[] bzlTransitiveDigest) {
        return new AutoValue_BazelModuleContext(label, repoMapping, filename, loads, bzlTransitiveDigest);
    }

    public final Label.PackageContext packageContext() {
        return Label.PackageContext.of(this.label().getPackageIdentifier(), this.repoMapping());
    }
}

