/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.clock;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.clock.Clock;
import com.google.devtools.build.lib.clock.JavaClock;
import java.util.concurrent.TimeUnit;

public abstract class BlazeClock {
    private static volatile Clock instance = new JavaClock();

    private BlazeClock() {
    }

    public static Clock instance() {
        return instance;
    }

    public static synchronized void setClock(Clock clock) {
        instance = clock;
    }

    public static long nanoTime() {
        return BlazeClock.instance().nanoTime();
    }

    public static NanosToMillisSinceEpochConverter createNanosToMillisSinceEpochConverter() {
        return BlazeClock.createNanosToMillisSinceEpochConverter(instance);
    }

    @VisibleForTesting
    public static NanosToMillisSinceEpochConverter createNanosToMillisSinceEpochConverter(Clock clock) {
        long nowInMillis = clock.currentTimeMillis();
        long nowInNanos = clock.nanoTime();
        return timeNanos -> nowInMillis - TimeUnit.NANOSECONDS.toMillis(nowInNanos - timeNanos);
    }

    public static MillisSinceEpochToNanosConverter createMillisSinceEpochToNanosConverter() {
        return BlazeClock.createMillisSinceEpochToNanosConverter(instance);
    }

    @VisibleForTesting
    public static MillisSinceEpochToNanosConverter createMillisSinceEpochToNanosConverter(Clock clock) {
        long nowInMillis = clock.currentTimeMillis();
        long nowInNanos = clock.nanoTime();
        return timeMillis -> nowInNanos - TimeUnit.MILLISECONDS.toNanos(nowInMillis - timeMillis);
    }

    public static interface MillisSinceEpochToNanosConverter {
        public long toNanos(long var1);
    }

    public static interface NanosToMillisSinceEpochConverter {
        public long toEpochMillis(long var1);
    }
}

