/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.bugreport;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.events.EventHandler;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import javax.annotation.Nullable;

public final class CrashContext {
    private final boolean haltJvm;
    private ImmutableList<String> args = ImmutableList.of();
    private boolean sendBugReport = true;
    private String extraOomInfo = "";
    @Nullable
    private String heapDumpPath = null;
    private EventHandler eventHandler = event -> System.err.println(event.getKind() + ": " + event.getMessage());

    public static CrashContext halt() {
        return new CrashContext(true);
    }

    public static CrashContext keepAlive() {
        return new CrashContext(false);
    }

    private CrashContext(boolean haltJvm) {
        this.haltJvm = haltJvm;
    }

    @CanIgnoreReturnValue
    public CrashContext withArgs(String ... args) {
        this.args = ImmutableList.copyOf(args);
        return this;
    }

    @CanIgnoreReturnValue
    public CrashContext withArgs(List<String> args) {
        this.args = ImmutableList.copyOf(args);
        return this;
    }

    @CanIgnoreReturnValue
    public CrashContext withoutBugReport() {
        this.sendBugReport = false;
        return this;
    }

    @CanIgnoreReturnValue
    public CrashContext withExtraOomInfo(String extraOomInfo) {
        this.extraOomInfo = extraOomInfo;
        return this;
    }

    public void setHeapDumpPath(String heapDumpPath) {
        this.heapDumpPath = heapDumpPath;
    }

    @CanIgnoreReturnValue
    public CrashContext reportingTo(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
        return this;
    }

    boolean shouldHaltJvm() {
        return this.haltJvm;
    }

    ImmutableList<String> getArgs() {
        return this.args;
    }

    boolean shouldSendBugReport() {
        return this.sendBugReport;
    }

    String getExtraOomInfo() {
        return this.extraOomInfo;
    }

    @Nullable
    String getHeapDumpPath() {
        return this.heapDumpPath;
    }

    EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("haltJvm", this.haltJvm).add("args", this.args).add("sendBugReport", this.sendBugReport).add("extraOomInfo", this.extraOomInfo).add("eventHandler", this.eventHandler).toString();
    }
}

