/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.bugreport;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.util.CrashFailureDetails;
import com.google.devtools.build.lib.util.DetailedExitCode;

public final class Crash {
    private final Throwable throwable;
    private final DetailedExitCode detailedExitCode;

    public static Crash from(Throwable throwable) {
        return new Crash(throwable, CrashFailureDetails.detailedExitCodeForThrowable(throwable));
    }

    public static Crash from(Throwable throwable, DetailedExitCode detailedExitCode) {
        return new Crash(throwable, detailedExitCode);
    }

    private Crash(Throwable throwable, DetailedExitCode detailedExitCode) {
        this.throwable = Preconditions.checkNotNull(throwable);
        this.detailedExitCode = Preconditions.checkNotNull(detailedExitCode);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public DetailedExitCode getDetailedExitCode() {
        return this.detailedExitCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("throwable", this.throwable).add("detailedExitCode", this.detailedExitCode).toString();
    }
}

