/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.bugreport;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.bugreport.BugReport;
import com.google.devtools.build.lib.bugreport.Crash;
import com.google.devtools.build.lib.bugreport.CrashContext;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.List;

public interface BugReporter {
    public static BugReporter defaultInstance() {
        return BugReport.REPORTER_INSTANCE;
    }

    @FormatMethod
    default public void logUnexpected(@FormatString String message, Object ... args) {
        BugReport.logUnexpected(message, args);
    }

    @FormatMethod
    default public void logUnexpected(Exception e, @FormatString String message, Object ... args) {
        BugReport.logUnexpected(e, message, args);
    }

    @FormatMethod
    default public void sendBugReport(@FormatString String message, Object ... args) {
        this.sendBugReport(new IllegalStateException(String.format(message, args)));
    }

    default public void sendBugReport(Throwable exception) {
        this.sendBugReport(exception, ImmutableList.of(), new String[0]);
    }

    public void sendBugReport(Throwable var1, List<String> var2, String ... var3);

    public void sendNonFatalBugReport(Throwable var1);

    public void handleCrash(Crash var1, CrashContext var2);
}

