/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.bugreport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.devtools.build.lib.analysis.BlazeVersionInfo;
import com.google.devtools.build.lib.bugreport.BugReporter;
import com.google.devtools.build.lib.bugreport.Crash;
import com.google.devtools.build.lib.bugreport.CrashContext;
import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.util.CrashFailureDetails;
import com.google.devtools.build.lib.util.CustomExitCodePublisher;
import com.google.devtools.build.lib.util.CustomFailureDetailPublisher;
import com.google.devtools.build.lib.util.DetailedExitCode;
import com.google.devtools.build.lib.util.ExitCode;
import com.google.devtools.build.lib.util.LoggingUtil;
import com.google.devtools.build.lib.util.TestType;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class BugReport {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final BugReporter REPORTER_INSTANCE = new DefaultBugReporter();
    private static final BlazeVersionInfo VERSION_INFO = BlazeVersionInfo.instance();
    private static BlazeRuntimeInterface runtime = null;
    @Nullable
    @GuardedBy(value="LOCK")
    private static Throwable lastCrashingThrowable = null;
    private static final Object LOCK = new Object();
    private static final boolean SHOULD_NOT_SEND_BUG_REPORT_BECAUSE_IN_TEST = TestType.isInTest() && System.getenv("ENABLE_BUG_REPORT_LOGGING_IN_TEST") == null;

    private BugReport() {
    }

    public static void setRuntime(BlazeRuntimeInterface newRuntime) {
        Preconditions.checkNotNull(newRuntime);
        Preconditions.checkState(runtime == null || TestType.isInTest(), "runtime already set: %s, %s", (Object)runtime, (Object)newRuntime);
        runtime = newRuntime;
    }

    private static String getProductName() {
        return runtime != null ? runtime.getProductName() : "<unknown>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Throwable getAndResetLastCrashingThrowableIfInTest() {
        if (TestType.isInTest()) {
            Object object = LOCK;
            synchronized (object) {
                Throwable result = lastCrashingThrowable;
                lastCrashingThrowable = null;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void maybePropagateLastCrashIfInTest() {
        if (TestType.isInTest()) {
            Object object = LOCK;
            synchronized (object) {
                Throwable lastUnprocessedThrowableInTest = BugReport.getAndResetLastCrashingThrowableIfInTest();
                if (lastUnprocessedThrowableInTest != null) {
                    throw new IllegalStateException("Unprocessed throwable detected in test", lastUnprocessedThrowableInTest);
                }
            }
        }
    }

    @FormatMethod
    public static void logUnexpected(@FormatString String message, Object ... args) {
        if (SHOULD_NOT_SEND_BUG_REPORT_BECAUSE_IN_TEST) {
            BugReport.sendBugReport(message, args);
        } else {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(50, TimeUnit.MILLISECONDS)).logVarargs("Unexpected state: " + message, args);
        }
    }

    @FormatMethod
    public static void logUnexpected(Exception e, @FormatString String message, Object ... args) {
        if (SHOULD_NOT_SEND_BUG_REPORT_BECAUSE_IN_TEST) {
            BugReport.sendBugReport(new IllegalStateException(String.format(message, args), e));
        } else {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(50, TimeUnit.MILLISECONDS)).withCause(e)).logVarargs("Unexpected state: " + message, args);
        }
    }

    @FormatMethod
    public static void sendBugReport(@FormatString String message, Object ... args) {
        BugReport.sendBugReport(new IllegalStateException(String.format(message, args)));
    }

    public static void sendBugReport(Throwable exception) {
        BugReport.sendBugReport(exception, ImmutableList.of(), new String[0]);
    }

    public static void sendBugReport(Throwable exception, List<String> args, String ... values) {
        BugReport.sendBugReportInternal(exception, true, BugReport.filterArgs(args), values);
    }

    public static void sendNonFatalBugReport(Throwable exception) {
        BugReport.sendBugReportInternal(exception, false, ImmutableList.of(), new String[0]);
    }

    private static void sendBugReportInternal(Throwable exception, boolean isFatal, List<String> args, String ... values) {
        if (SHOULD_NOT_SEND_BUG_REPORT_BECAUSE_IN_TEST) {
            Throwables.throwIfUnchecked(exception);
            throw new IllegalStateException("Bug reports in tests should crash: " + args + ", " + Arrays.toString(values), exception);
        }
        if (!VERSION_INFO.isReleasedBlaze()) {
            ((GoogleLogger.Api)logger.atInfo()).log("(Not a released binary; not logged.)");
            return;
        }
        BugReport.logException(exception, isFatal, BugReport.filterArgs(args), values);
    }

    public static RuntimeException handleCrash(Throwable throwable, String ... args) {
        BugReport.handleCrash(Crash.from(throwable), CrashContext.halt().withArgs(args));
        throw new IllegalStateException("Should have halted", throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleCrash(Crash crash, CrashContext ctx) {
        int numericExitCode = crash.getDetailedExitCode().getExitCode().getNumericExitCode();
        Throwable throwable = crash.getThrowable();
        if (runtime != null) {
            runtime.fillInCrashContext(ctx);
        }
        try {
            Object object = LOCK;
            synchronized (object) {
                String heapDumpPath;
                Object crashMsg;
                boolean isOom;
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(throwable)).log("Handling crash with %s", ctx);
                if (TestType.isInTest()) {
                    lastCrashingThrowable = throwable;
                }
                if (isOom = crash.getDetailedExitCode().getExitCode().equals(ExitCode.OOM_ERROR)) {
                    crashMsg = BugReport.constructOomExitMessage(ctx.getExtraOomInfo());
                    heapDumpPath = ctx.getHeapDumpPath();
                    if (heapDumpPath != null) {
                        crashMsg = (String)crashMsg + " An attempt will be made to write a heap dump to " + heapDumpPath + ".";
                    }
                } else {
                    crashMsg = BugReport.getProductName() + " crashed due to an internal error.";
                    heapDumpPath = null;
                }
                crashMsg = (String)crashMsg + " Printing stack trace:\n" + Throwables.getStackTraceAsString(throwable);
                ctx.getEventHandler().handle(Event.fatal((String)crashMsg));
                try {
                    BugReport.emitExitData(crash, ctx, numericExitCode, heapDumpPath);
                    if (ctx.shouldSendBugReport() && !isOom && !TestType.isInTest()) {
                        BugReport.sendBugReport(throwable, ctx.getArgs(), new String[0]);
                    }
                }
                finally {
                    if (ctx.shouldHaltJvm()) {
                        Runtime.getRuntime().halt(numericExitCode);
                    }
                }
            }
        }
        catch (Throwable t2) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(t2)).log("Threw while crashing");
            System.err.println("ERROR: A crash occurred while " + BugReport.getProductName() + " was trying to handle a crash! Please file a bug against " + BugReport.getProductName() + " and include the information below.");
            System.err.println("Original uncaught exception:");
            throwable.printStackTrace(System.err);
            System.err.println("Exception encountered during BugReport#handleCrash:");
            t2.printStackTrace(System.err);
        }
        finally {
            if (ctx.shouldHaltJvm()) {
                Runtime.getRuntime().halt(numericExitCode);
            }
        }
        if (!ctx.shouldHaltJvm()) {
            return;
        }
        ((GoogleLogger.Api)logger.atSevere()).log("Failed to crash in handleCrash");
        throw new IllegalStateException("Should have halted", throwable);
    }

    private static void emitExitData(Crash crash, CrashContext ctx, int numericExitCode, @Nullable String heapDumpPath) {
        if (ctx.shouldHaltJvm()) {
            if (CustomExitCodePublisher.maybeWriteExitStatusFile(numericExitCode)) {
                ((GoogleLogger.Api)logger.atInfo()).log("Wrote exit status file.");
            } else {
                ((GoogleLogger.Api)logger.atWarning()).log("Did not write exit status file; check stderr for errors.");
            }
        }
        if (CustomFailureDetailPublisher.maybeWriteFailureDetailFile(crash.getDetailedExitCode().getFailureDetail())) {
            ((GoogleLogger.Api)logger.atInfo()).log("Wrote failure detail file.");
        } else {
            ((GoogleLogger.Api)logger.atWarning()).log("Did not write failure detail file; check stderr for errors.");
        }
        if (heapDumpPath != null) {
            ((GoogleLogger.Api)logger.atInfo()).log("Attempting to dump heap to %s", heapDumpPath);
            try {
                BugReport.dumpHeap(heapDumpPath);
                ((GoogleLogger.Api)logger.atInfo()).log("Heap dump complete");
            }
            catch (Throwable t2) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(t2)).log("Heap dump failed");
            }
        }
        if (runtime != null) {
            runtime.cleanUpForCrash(crash.getDetailedExitCode());
            ((GoogleLogger.Api)logger.atInfo()).log("Cleaned up runtime.");
        } else {
            ((GoogleLogger.Api)logger.atInfo()).log("No runtime to clean.");
        }
    }

    public static String constructOomExitMessage(@Nullable String extraInfo) {
        String msg = BugReport.getProductName() + " ran out of memory and crashed.";
        return Strings.isNullOrEmpty(extraInfo) ? msg : msg + " " + extraInfo;
    }

    private static void dumpHeap(String path) throws IOException {
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        mxBean.dumpHeap(path, true);
    }

    @Nullable
    private static ImmutableList<String> filterArgs(Iterable<String> args) {
        if (args == null) {
            return null;
        }
        ImmutableList.Builder filteredArgs = ImmutableList.builder();
        for (String arg : args) {
            if (arg == null || arg.startsWith("--client_env=") || arg.startsWith("--default_override=")) continue;
            filteredArgs.add(arg);
        }
        return filteredArgs.build();
    }

    @VisibleForTesting
    static void logException(Throwable exception, boolean isCrash, List<String> args, String ... values) {
        Level level;
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(exception)).log("Exception");
        Object preamble = CrashFailureDetails.oomDetected() ? "While OOMing, " + BugReport.getProductName() : BugReport.getProductName();
        Level level2 = level = isCrash ? Level.SEVERE : Level.WARNING;
        preamble = !isCrash ? (String)preamble + " had a non fatal error with args: " : (exception instanceof OutOfMemoryError ? (String)preamble + " OOMError: " : (String)preamble + " crashed with args: ");
        ((GoogleLogger.Api)logger.atInfo()).log("Calling logToRemote");
        LoggingUtil.logToRemote(level, (String)preamble + Joiner.on(' ').join(args), exception, values);
        ((GoogleLogger.Api)logger.atInfo()).log("Call to logToRemote complete");
    }

    private static final class DefaultBugReporter
    implements BugReporter {
        private DefaultBugReporter() {
        }

        @Override
        public void sendBugReport(Throwable exception, List<String> args, String ... values) {
            BugReport.sendBugReport(exception, args, values);
        }

        @Override
        public void sendNonFatalBugReport(Throwable exception) {
            BugReport.sendNonFatalBugReport(exception);
        }

        @Override
        public void handleCrash(Crash crash, CrashContext ctx) {
            BugReport.handleCrash(crash, ctx);
        }
    }

    public static interface BlazeRuntimeInterface {
        public String getProductName();

        public void fillInCrashContext(CrashContext var1);

        public void cleanUpForCrash(DetailedExitCode var1);
    }
}

