/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config.transitions;

import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.analysis.config.BuildOptions;
import com.google.devtools.build.lib.analysis.config.BuildOptionsView;
import com.google.devtools.build.lib.analysis.config.transitions.ConfigurationTransition;
import com.google.devtools.build.lib.events.EventHandler;
import java.util.Collection;
import java.util.Map;

public interface SplitTransition
extends ConfigurationTransition {
    public Map<String, BuildOptions> split(BuildOptionsView var1, EventHandler var2) throws InterruptedException;

    public static boolean equals(BuildOptions options, Collection<BuildOptions> splitOptions) {
        return splitOptions.size() == 1 && Iterables.getOnlyElement(splitOptions).equals(options);
    }

    @Override
    default public Map<String, BuildOptions> apply(BuildOptionsView buildOptions, EventHandler eventHandler) throws InterruptedException {
        Map<String, BuildOptions> splitOptions = this.split(buildOptions, eventHandler);
        Verify.verifyNotNull(splitOptions, "Split transition output may not be null", new Object[0]);
        Verify.verify(!splitOptions.isEmpty(), "Split transition output may not be empty", new Object[0]);
        return splitOptions;
    }

    @Override
    default public String reasonForOverride() {
        return "This is a fundamental transition modeling the need for multiply configured deps";
    }
}

