/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.analysis.config.AutoValue_ToolchainTypeRequirement;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.starlarkbuildapi.config.StarlarkToolchainTypeRequirement;

@AutoValue
public abstract class ToolchainTypeRequirement
implements StarlarkToolchainTypeRequirement {
    public static ToolchainTypeRequirement create(Label toolchainType) {
        return ToolchainTypeRequirement.builder(toolchainType).build();
    }

    public static Builder builder(Label toolchainType) {
        return new AutoValue_ToolchainTypeRequirement.Builder().toolchainType(toolchainType).mandatory(true);
    }

    public static ToolchainTypeRequirement strictest(ToolchainTypeRequirement first, ToolchainTypeRequirement second) {
        Preconditions.checkArgument(first.toolchainType().equals(second.toolchainType()), "Cannot use strictest() for two instances with different type labels.");
        if (first.mandatory()) {
            return first;
        }
        if (second.mandatory()) {
            return second;
        }
        return first;
    }

    @Override
    public abstract Label toolchainType();

    @Override
    public abstract boolean mandatory();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static interface Builder {
        public Builder toolchainType(Label var1);

        public Builder mandatory(boolean var1);

        public ToolchainTypeRequirement build();
    }
}

