/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.Options;
import com.google.devtools.common.options.OptionsBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;

public abstract class FragmentOptions
extends OptionsBase
implements Cloneable {
    public FragmentOptions clone() {
        try {
            return (FragmentOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public FragmentOptions getDefault() {
        return (FragmentOptions)Options.getDefaults(this.getClass());
    }

    public FragmentOptions getExec() {
        return this.getDefault();
    }

    public FragmentOptions getNormalized() {
        return this;
    }

    protected static List<String> dedupAndSort(List<String> values) {
        ImmutableList<String> result = ImmutableList.sortedCopyOf(new TreeSet<String>(values));
        return result.equals(values) ? values : result;
    }

    protected static List<String> dedupeOnly(List<String> values) {
        HashSet<String> alreadySeen = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values) {
            if (!alreadySeen.add(value)) continue;
            result.add(value);
        }
        if (result.size() == values.size()) {
            return values;
        }
        return result;
    }

    public Map<OptionDefinition, SelectRestriction> getSelectRestrictions() {
        return ImmutableMap.of();
    }

    public static final class SelectRestriction {
        private final boolean visibleWithinToolsPackage;
        @Nullable
        private final String errorMessage;

        public SelectRestriction(boolean visibleWithinToolsPackage, @Nullable String errorMessage) {
            this.visibleWithinToolsPackage = visibleWithinToolsPackage;
            this.errorMessage = errorMessage;
        }

        public boolean isVisibleWithinToolsPackage() {
            return this.visibleWithinToolsPackage;
        }

        @Nullable
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

