/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.analysis.config.Fragment;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.ClassName;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FragmentClassSet
extends AbstractSet<Class<? extends Fragment>> {
    @SerializationConstant
    public static final Comparator<Class<? extends Fragment>> LEXICAL_FRAGMENT_SORTER = Comparator.comparing(Class::getName);
    private static final Interner<FragmentClassSet> interner = BlazeInterners.newWeakInterner();
    private final ImmutableSortedSet<Class<? extends Fragment>> fragments;
    private final int hashCode;

    public static FragmentClassSet of(Collection<Class<? extends Fragment>> fragments) {
        ImmutableSortedSet<Class<? extends Fragment>> sortedFragments = ImmutableSortedSet.copyOf(LEXICAL_FRAGMENT_SORTER, fragments);
        return interner.intern(new FragmentClassSet(sortedFragments, sortedFragments.hashCode()));
    }

    private FragmentClassSet(ImmutableSortedSet<Class<? extends Fragment>> fragments, int hashCode) {
        this.fragments = fragments;
        this.hashCode = hashCode;
    }

    @Override
    public int size() {
        return this.fragments.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.fragments.contains(o);
    }

    public FragmentClassSet trim(Class<? extends Fragment> fragment) {
        if (!this.contains(fragment)) {
            return this;
        }
        return FragmentClassSet.of(Sets.filter(this.fragments, Predicates.not(fragment::equals)));
    }

    @Override
    public Iterator<Class<? extends Fragment>> iterator() {
        return this.fragments.iterator();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FragmentClassSet)) {
            return false;
        }
        FragmentClassSet that = (FragmentClassSet)other;
        return this.hashCode == that.hashCode && this.fragments.equals(that.fragments);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return Collections2.transform(this.fragments, ClassName::getSimpleNameWithOuter).toString();
    }
}

