/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.devtools.build.lib.analysis.config.AutoValue_FeatureSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@AutoValue
public abstract class FeatureSet {
    public static final FeatureSet EMPTY = FeatureSet.of(ImmutableSet.of(), ImmutableSet.of());

    public abstract ImmutableSet<String> on();

    public abstract ImmutableSet<String> off();

    private static FeatureSet of(Set<String> on, Set<String> off) {
        return new AutoValue_FeatureSet(ImmutableSortedSet.copyOf(on), ImmutableSortedSet.copyOf(off));
    }

    public static FeatureSet parse(Iterable<String> features) {
        HashMap<String, Boolean> featureToState = new HashMap<String, Boolean>();
        for (String feature : features) {
            if (feature.startsWith("-")) {
                featureToState.put(feature.substring(1), false);
                continue;
            }
            if (feature.equals("no_layering_check")) {
                featureToState.put("layering_check", false);
                continue;
            }
            featureToState.putIfAbsent(feature, true);
        }
        return FeatureSet.fromMap(featureToState);
    }

    private static FeatureSet fromMap(Map<String, Boolean> featureToState) {
        return FeatureSet.of(Maps.filterValues(featureToState, Boolean.TRUE::equals).keySet(), Maps.filterValues(featureToState, Boolean.FALSE::equals).keySet());
    }

    private static void mergeSetIntoMap(Set<String> features, boolean state, Map<String, Boolean> featureToState) {
        for (String feature : features) {
            featureToState.put(feature, state);
        }
    }

    public static FeatureSet merge(FeatureSet coarse, FeatureSet fine) {
        HashMap<String, Boolean> featureToState = new HashMap<String, Boolean>();
        FeatureSet.mergeSetIntoMap(coarse.on(), true, featureToState);
        FeatureSet.mergeSetIntoMap(coarse.off(), false, featureToState);
        FeatureSet.mergeSetIntoMap(fine.on(), true, featureToState);
        FeatureSet.mergeSetIntoMap(fine.off(), false, featureToState);
        return FeatureSet.fromMap(featureToState);
    }

    public static FeatureSet mergeWithGlobalFeatures(FeatureSet base, FeatureSet global) {
        HashMap<String, Boolean> featureToState = new HashMap<String, Boolean>();
        FeatureSet.mergeSetIntoMap(global.on(), true, featureToState);
        FeatureSet.mergeSetIntoMap(base.on(), true, featureToState);
        FeatureSet.mergeSetIntoMap(base.off(), false, featureToState);
        FeatureSet.mergeSetIntoMap(global.off(), false, featureToState);
        return FeatureSet.fromMap(featureToState);
    }

    public final ImmutableList<String> toStringList() {
        return Streams.concat(this.on().stream(), this.off().stream().map(s2 -> "-" + s2)).collect(ImmutableList.toImmutableList());
    }
}

