/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.cmdline.RepositoryMapping;
import com.google.devtools.build.lib.cmdline.RepositoryName;
import com.google.devtools.build.lib.packages.BuildType;
import com.google.devtools.build.lib.packages.Type;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.Converters;
import com.google.devtools.common.options.EnumConverter;
import com.google.devtools.common.options.OptionsParsingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.StarlarkInt;

public class CoreOptionConverters {
    public static final ImmutableMap<Type<?>, Converter<?>> BUILD_SETTING_CONVERTERS = new ImmutableMap.Builder<Type<StarlarkInt>, StarlarkIntConverter>().put(Type.INTEGER, new StarlarkIntConverter()).put(Type.BOOLEAN, (StarlarkIntConverter)((Object)new Converters.BooleanConverter())).put(Type.STRING, (StarlarkIntConverter)((Object)new Converters.StringConverter())).put(Type.STRING_LIST, (StarlarkIntConverter)((Object)new Converters.CommaSeparatedOptionListConverter())).put((Type.ListType<String>)BuildType.LABEL, (StarlarkIntConverter)((Object)new LabelConverter())).put(BuildType.LABEL_LIST, (StarlarkIntConverter)((Object)new LabelListConverter())).put((Type.ListType<Label>)BuildType.NODEP_LABEL, (StarlarkIntConverter)((Object)new LabelConverter())).buildOrThrow();

    private CoreOptionConverters() {
    }

    private static Label convertOptionsLabel(String input, @Nullable Object conversionContext) throws OptionsParsingException {
        try {
            if (conversionContext instanceof Label.PackageContext) {
                return Label.parseWithPackageContext((String)input, (Label.PackageContext)conversionContext);
            }
            if (!((String)input).startsWith("/") && !((String)input).startsWith("@")) {
                input = "//" + (String)input;
            }
            if (conversionContext == null) {
                return Label.parseCanonical((String)input);
            }
            Preconditions.checkArgument(conversionContext instanceof RepositoryMapping, "bad conversion context type: %s", (Object)conversionContext.getClass().getName());
            return Label.parseWithRepoContext((String)input, Label.RepoContext.of(RepositoryName.MAIN, (RepositoryMapping)conversionContext));
        }
        catch (LabelSyntaxException e) {
            throw new OptionsParsingException(e.getMessage());
        }
    }

    public static class StrictDepsConverter
    extends EnumConverter<StrictDepsMode> {
        public StrictDepsConverter() {
            super(StrictDepsMode.class, "strict dependency checking level");
        }
    }

    public static enum StrictDepsMode {
        OFF,
        WARN,
        ERROR,
        STRICT,
        DEFAULT;

    }

    public static class LabelMapConverter
    implements Converter<Map<String, Label>> {
        @Override
        public Map<String, Label> convert(String input, Object conversionContext) throws OptionsParsingException {
            LinkedHashMap<String, Label> result = new LinkedHashMap<String, Label>();
            for (String entry : Splitter.on(",").omitEmptyStrings().trimResults().split(input)) {
                Label label;
                String key;
                int sepIndex = entry.indexOf(61);
                if (sepIndex < 0) {
                    key = entry;
                    label = null;
                } else {
                    key = entry.substring(0, sepIndex);
                    String value = entry.substring(sepIndex + 1);
                    Label label2 = label = value.isEmpty() ? null : CoreOptionConverters.convertOptionsLabel(value, conversionContext);
                }
                if (result.containsKey(key)) {
                    throw new OptionsParsingException("Key '" + key + "' appears twice");
                }
                result.put(key, label);
            }
            return Collections.unmodifiableMap(result);
        }

        @Override
        public String getTypeDescription() {
            return "a comma-separated list of keys optionally followed by '=' and a label";
        }
    }

    public static class EmptyToNullLabelConverter
    implements Converter<Label> {
        @Override
        @Nullable
        public Label convert(String input, Object conversionContext) throws OptionsParsingException {
            return input.isEmpty() ? null : CoreOptionConverters.convertOptionsLabel(input, conversionContext);
        }

        @Override
        public String getTypeDescription() {
            return "a build target label";
        }
    }

    public static class LabelOrderedSetConverter
    extends LabelListConverter {
        @Override
        public List<Label> convert(String input, Object conversionContext) throws OptionsParsingException {
            HashSet<Label> alreadySeen = new HashSet<Label>();
            ImmutableList.Builder result = ImmutableList.builder();
            Iterator iterator = super.convert(input, conversionContext).iterator();
            while (iterator.hasNext()) {
                Label label = (Label)iterator.next();
                if (!alreadySeen.add(label)) continue;
                result.add(label);
            }
            return result.build();
        }
    }

    public static class LabelListConverter
    implements Converter<List<Label>> {
        @Override
        public List<Label> convert(String input, Object conversionContext) throws OptionsParsingException {
            ImmutableList.Builder result = ImmutableList.builder();
            for (String label : Splitter.on(",").omitEmptyStrings().split(input)) {
                result.add(CoreOptionConverters.convertOptionsLabel(label, conversionContext));
            }
            return result.build();
        }

        @Override
        public String getTypeDescription() {
            return "a build target label";
        }
    }

    public static class LabelConverter
    implements Converter<Label> {
        @Override
        public Label convert(String input, Object conversionContext) throws OptionsParsingException {
            return CoreOptionConverters.convertOptionsLabel(input, conversionContext);
        }

        @Override
        public String getTypeDescription() {
            return "a build target label";
        }
    }

    private static class StarlarkIntConverter
    extends Converter.Contextless<StarlarkInt> {
        private StarlarkIntConverter() {
        }

        @Override
        public StarlarkInt convert(String input) throws OptionsParsingException {
            try {
                return StarlarkInt.parse(input, 0);
            }
            catch (NumberFormatException ex) {
                throw new OptionsParsingException("invalid int: " + ex.getMessage());
            }
        }

        @Override
        public String getTypeDescription() {
            return "an int";
        }
    }
}

