/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.analysis.config.BuildOptions;
import com.google.devtools.build.lib.analysis.config.FragmentOptions;
import java.util.Set;

public class BuildOptionsView
implements Cloneable {
    private final BuildOptions options;
    private final Set<Class<? extends FragmentOptions>> allowedFragments;

    public BuildOptionsView(BuildOptions options, Set<Class<? extends FragmentOptions>> allowedFragments) {
        this.options = options;
        this.allowedFragments = allowedFragments;
    }

    public <T extends FragmentOptions> T get(Class<T> optionsClass) {
        return this.options.get(this.checkFragment(optionsClass));
    }

    public boolean contains(Class<? extends FragmentOptions> optionsClass) {
        return this.options.contains(this.checkFragment(optionsClass));
    }

    public BuildOptionsView clone() {
        return new BuildOptionsView(this.options.clone(), this.allowedFragments);
    }

    public BuildOptions underlying() {
        return this.options;
    }

    private <T extends FragmentOptions> Class<T> checkFragment(Class<T> optionsClass) {
        Preconditions.checkArgument(this.allowedFragments.contains(optionsClass), "Can't access %s in allowed fragments %s", optionsClass, this.allowedFragments);
        return optionsClass;
    }
}

