/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.analysis.config.FragmentOptions;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.Fingerprint;
import com.google.devtools.build.lib.util.OrderedSetMultimap;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.OptionsParsingResult;
import com.google.devtools.common.options.OptionsProvider;
import com.google.devtools.common.options.ParsedOptionDescription;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class BuildOptions
implements Cloneable {
    @SerializationConstant
    static final Comparator<Class<? extends FragmentOptions>> LEXICAL_FRAGMENT_OPTIONS_COMPARATOR = Comparator.comparing(Class::getName);
    private final ImmutableMap<Class<? extends FragmentOptions>, FragmentOptions> fragmentOptionsMap;
    private final ImmutableMap<Label, Object> starlarkOptionsMap;
    @Nullable
    private volatile String checksum = null;

    public static Map<Label, Object> labelizeStarlarkOptions(Map<String, Object> starlarkOptions) {
        return starlarkOptions.entrySet().stream().collect(Collectors.toMap(e -> Label.parseCanonicalUnchecked((String)e.getKey()), Map.Entry::getValue));
    }

    public static BuildOptions getDefaultBuildOptionsForFragments(Iterable<Class<? extends FragmentOptions>> fragmentClasses) {
        try {
            return BuildOptions.of(fragmentClasses, new String[0]);
        }
        catch (OptionsParsingException e) {
            throw new IllegalArgumentException("Failed to parse empty options", e);
        }
    }

    public BuildOptions createExecOptions() {
        Builder builder = BuildOptions.builder();
        for (FragmentOptions options : this.fragmentOptionsMap.values()) {
            builder.addFragmentOptions(options.getExec());
        }
        return builder.addStarlarkOptions(this.starlarkOptionsMap).build();
    }

    public static BuildOptions of(Iterable<Class<? extends FragmentOptions>> optionsList, OptionsProvider provider) {
        Builder builder = BuildOptions.builder();
        for (Class<? extends FragmentOptions> optionsClass : optionsList) {
            builder.addFragmentOptions(provider.getOptions(optionsClass));
        }
        return builder.addStarlarkOptions(BuildOptions.labelizeStarlarkOptions(provider.getStarlarkOptions())).build();
    }

    @VisibleForTesting
    public static BuildOptions of(Iterable<Class<? extends FragmentOptions>> optionsList, String ... args) throws OptionsParsingException {
        Builder builder = BuildOptions.builder();
        OptionsParser parser = OptionsParser.builder().optionsClasses(optionsList).build();
        parser.parse(args);
        for (Class<? extends FragmentOptions> optionsClass : optionsList) {
            builder.addFragmentOptions(parser.getOptions(optionsClass));
        }
        return builder.build();
    }

    @VisibleForTesting
    public static BuildOptions of(Map<Label, Object> starlarkOptions) {
        return BuildOptions.builder().addStarlarkOptions(starlarkOptions).build();
    }

    public <T extends FragmentOptions> T get(Class<T> optionsClass) {
        FragmentOptions options = this.fragmentOptionsMap.get(optionsClass);
        Preconditions.checkNotNull(options, "fragment options unavailable: %s", optionsClass);
        return (T)((FragmentOptions)optionsClass.cast(options));
    }

    public boolean contains(Class<? extends FragmentOptions> optionsClass) {
        return this.fragmentOptionsMap.containsKey(optionsClass);
    }

    public boolean hasNoConfig() {
        return this.fragmentOptionsMap.size() == 1 && ((FragmentOptions)Iterables.getOnlyElement(this.fragmentOptionsMap.values())).getClass().getSimpleName().equals("CoreOptions") && this.starlarkOptionsMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checksum() {
        if (this.checksum == null) {
            BuildOptions buildOptions = this;
            synchronized (buildOptions) {
                if (this.checksum == null) {
                    if (this.fragmentOptionsMap.isEmpty() && this.starlarkOptionsMap.isEmpty()) {
                        this.checksum = "0".repeat(64);
                    } else {
                        Fingerprint fingerprint = new Fingerprint();
                        for (FragmentOptions options : this.fragmentOptionsMap.values()) {
                            fingerprint.addString(options.cacheKey());
                        }
                        fingerprint.addString(OptionsBase.mapToCacheKey(this.starlarkOptionsMap));
                        this.checksum = fingerprint.hexDigestAndReset();
                    }
                }
            }
        }
        return this.checksum;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("checksum", this.checksum()).add("fragmentOptions", this.fragmentOptionsMap.values()).add("starlarkOptions", this.starlarkOptionsMap).toString();
    }

    public ImmutableCollection<FragmentOptions> getNativeOptions() {
        return this.fragmentOptionsMap.values();
    }

    public ImmutableSet<Class<? extends FragmentOptions>> getFragmentClasses() {
        return this.fragmentOptionsMap.keySet();
    }

    public ImmutableMap<Label, Object> getStarlarkOptions() {
        return this.starlarkOptionsMap;
    }

    public BuildOptions clone() {
        ImmutableMap.Builder<Class, FragmentOptions> nativeOptionsBuilder = ImmutableMap.builderWithExpectedSize(this.fragmentOptionsMap.size());
        for (Map.Entry entry : this.fragmentOptionsMap.entrySet()) {
            nativeOptionsBuilder.put((Class)entry.getKey(), ((FragmentOptions)entry.getValue()).clone());
        }
        return new BuildOptions(nativeOptionsBuilder.buildOrThrow(), ImmutableMap.copyOf(this.starlarkOptionsMap));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildOptions)) {
            return false;
        }
        return this.checksum().equals(((BuildOptions)other).checksum());
    }

    public int hashCode() {
        return 31 + this.checksum().hashCode();
    }

    private BuildOptions(ImmutableMap<Class<? extends FragmentOptions>, FragmentOptions> fragmentOptionsMap, ImmutableMap<Label, Object> starlarkOptionsMap) {
        this.fragmentOptionsMap = fragmentOptionsMap;
        this.starlarkOptionsMap = starlarkOptionsMap;
    }

    public BuildOptions applyParsingResult(OptionsParsingResult parsingResult) {
        Map<Class<? extends FragmentOptions>, FragmentOptions> modifiedFragments = this.toModifiedFragments(parsingResult);
        Builder builder = BuildOptions.builder();
        for (Map.Entry classAndFragment : this.fragmentOptionsMap.entrySet()) {
            Class fragmentClass = (Class)classAndFragment.getKey();
            if (modifiedFragments.containsKey(fragmentClass)) {
                builder.addFragmentOptions(modifiedFragments.get(fragmentClass));
                continue;
            }
            builder.addFragmentOptions((FragmentOptions)classAndFragment.getValue());
        }
        HashMap<Label, Object> starlarkOptions = new HashMap<Label, Object>(this.starlarkOptionsMap);
        Map<Label, Object> parsedStarlarkOptions = BuildOptions.labelizeStarlarkOptions(parsingResult.getStarlarkOptions());
        for (Map.Entry<Label, Object> starlarkOption : parsedStarlarkOptions.entrySet()) {
            starlarkOptions.put(starlarkOption.getKey(), starlarkOption.getValue());
        }
        builder.addStarlarkOptions(starlarkOptions);
        return builder.build();
    }

    private Map<Class<? extends FragmentOptions>, FragmentOptions> toModifiedFragments(OptionsParsingResult parsingResult) {
        HashMap<Class<? extends FragmentOptions>, FragmentOptions> replacedOptions = new HashMap<Class<? extends FragmentOptions>, FragmentOptions>();
        for (ParsedOptionDescription parsedOption : parsingResult.asListOfExplicitOptions()) {
            OptionDefinition optionDefinition = parsedOption.getOptionDefinition();
            Class<?> fragmentOptionClass = optionDefinition.getField().getDeclaringClass();
            FragmentOptions originalFragment = this.fragmentOptionsMap.get(fragmentOptionClass);
            if (originalFragment == null) continue;
            FragmentOptions newOptions = replacedOptions.computeIfAbsent(fragmentOptionClass, unused -> originalFragment.clone());
            try {
                Object value = parsingResult.getOptionValueDescription(optionDefinition.getOptionName()).getValue();
                optionDefinition.getField().set(newOptions, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Couldn't set " + optionDefinition.getField(), e);
            }
        }
        return replacedOptions;
    }

    public boolean matches(OptionsParsingResult parsingResult) throws OptionsParsingException {
        HashSet<OptionDefinition> ignoredDefinitions = new HashSet<OptionDefinition>();
        for (ParsedOptionDescription parsedOption : parsingResult.asListOfExplicitOptions()) {
            OptionDefinition optionDefinition = parsedOption.getOptionDefinition();
            Class<?> fragmentClass = optionDefinition.getField().getDeclaringClass();
            FragmentOptions originalFragment = this.fragmentOptionsMap.get(fragmentClass);
            if (originalFragment == null) {
                ignoredDefinitions.add(optionDefinition);
                continue;
            }
            Object originalValue = originalFragment.asMap().get(optionDefinition.getOptionName());
            if (Objects.equals(originalValue, parsedOption.getConvertedValue())) continue;
            return false;
        }
        Map<Label, Object> starlarkOptions = BuildOptions.labelizeStarlarkOptions(parsingResult.getStarlarkOptions());
        MapDifference<Label, Object> starlarkDifference = Maps.difference(this.starlarkOptionsMap, starlarkOptions);
        if (starlarkDifference.entriesInCommon().size() < starlarkOptions.size()) {
            return false;
        }
        return ignoredDefinitions.size() != parsingResult.asListOfExplicitOptions().size() || !starlarkOptions.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return BuildOptions.builder().merge(this.clone());
    }

    public static OptionsDiff diff(BuildOptions first, BuildOptions second) {
        return BuildOptions.diff(new OptionsDiff(), first, second);
    }

    public static OptionsDiff diff(OptionsDiff diff, BuildOptions first, BuildOptions second) {
        Preconditions.checkArgument(!diff.hasStarlarkOptions, "OptionsDiff cannot handle multiple 'second' BuildOptions with Starlark options and is trying to diff against %s", (Object)diff);
        Preconditions.checkNotNull(first);
        Preconditions.checkNotNull(second);
        if (first.equals(second)) {
            return diff;
        }
        ImmutableSet firstOptionClasses = first.getNativeOptions().stream().map(Object::getClass).collect(ImmutableSet.toImmutableSet());
        ImmutableSet secondOptionClasses = second.getNativeOptions().stream().map(Object::getClass).collect(ImmutableSet.toImmutableSet());
        Sets.difference(firstOptionClasses, secondOptionClasses).forEach(x$0 -> diff.addExtraFirstFragment((Class<? extends FragmentOptions>)x$0));
        Sets.difference(secondOptionClasses, firstOptionClasses).stream().map(second::get).forEach(x$0 -> diff.addExtraSecondFragment((FragmentOptions)x$0));
        for (Class clazz : Sets.intersection(firstOptionClasses, secondOptionClasses)) {
            Object secondOptions;
            Object firstOptions = first.get(clazz);
            if (firstOptions == (secondOptions = second.get(clazz))) continue;
            for (OptionDefinition definition : OptionsParser.getOptionDefinitions(clazz)) {
                Object secondValue;
                Object firstValue = ((OptionsBase)firstOptions).getValueFromDefinition(definition);
                if (Objects.equals(firstValue, secondValue = ((OptionsBase)secondOptions).getValueFromDefinition(definition))) continue;
                diff.addDiff(clazz, definition, firstValue, secondValue);
            }
        }
        ImmutableMap<Label, Object> starlarkFirst = first.starlarkOptionsMap;
        ImmutableMap<Label, Object> starlarkSecond = second.starlarkOptionsMap;
        for (Label buildSetting : Sets.union(starlarkFirst.keySet(), starlarkSecond.keySet())) {
            if (starlarkFirst.get(buildSetting) == null) {
                diff.addExtraSecondStarlarkOption(buildSetting, starlarkSecond.get(buildSetting));
                continue;
            }
            if (starlarkSecond.get(buildSetting) == null) {
                diff.addExtraFirstStarlarkOption(buildSetting);
                continue;
            }
            if (starlarkFirst.get(buildSetting).equals(starlarkSecond.get(buildSetting))) continue;
            diff.putStarlarkDiff(buildSetting, starlarkFirst.get(buildSetting), starlarkSecond.get(buildSetting));
        }
        return diff;
    }

    public static final class MapBackedChecksumCache
    implements OptionsChecksumCache {
        private final ConcurrentMap<String, BuildOptions> map = new ConcurrentHashMap<String, BuildOptions>();

        @Override
        public BuildOptions getOptions(String checksum) {
            return (BuildOptions)this.map.get(checksum);
        }

        @Override
        public void prime(BuildOptions options) {
            this.map.putIfAbsent(options.checksum(), options);
        }
    }

    public static interface OptionsChecksumCache {
        public BuildOptions getOptions(String var1);

        public void prime(BuildOptions var1);
    }

    private static final class Codec
    implements ObjectCodec<BuildOptions> {
        private Codec() {
        }

        @Override
        public Class<BuildOptions> getEncodedClass() {
            return BuildOptions.class;
        }

        @Override
        public void serialize(SerializationContext context, BuildOptions options, CodedOutputStream codedOut) throws IOException {
            context.getDependency(OptionsChecksumCache.class).prime(options);
            codedOut.writeStringNoTag(options.checksum());
        }

        @Override
        public BuildOptions deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
            String checksum = codedIn.readString();
            BuildOptions result = context.getDependency(OptionsChecksumCache.class).getOptions(checksum);
            if (result == null) {
                throw new SerializationException("No options instance for " + checksum);
            }
            return result;
        }
    }

    public static final class OptionsDiff {
        private final Multimap<Class<? extends FragmentOptions>, OptionDefinition> differingOptions = ArrayListMultimap.create();
        private final Map<OptionDefinition, Object> first = new LinkedHashMap<OptionDefinition, Object>();
        private final Multimap<OptionDefinition, Object> second = OrderedSetMultimap.create();
        private final Set<Class<? extends FragmentOptions>> extraFirstFragments = new HashSet<Class<? extends FragmentOptions>>();
        private final Set<FragmentOptions> extraSecondFragments = new HashSet<FragmentOptions>();
        private final Map<Label, Object> starlarkFirst = new LinkedHashMap<Label, Object>();
        private final Map<Label, Object> starlarkSecond = new LinkedHashMap<Label, Object>();
        private final List<Label> extraStarlarkOptionsFirst = new ArrayList<Label>();
        private final Map<Label, Object> extraStarlarkOptionsSecond = new HashMap<Label, Object>();
        private boolean hasStarlarkOptions = false;

        @VisibleForTesting
        Set<Class<? extends FragmentOptions>> getExtraFirstFragmentClassesForTesting() {
            return this.extraFirstFragments;
        }

        @VisibleForTesting
        Set<FragmentOptions> getExtraSecondFragmentsForTesting() {
            return this.extraSecondFragments;
        }

        public Map<OptionDefinition, Object> getFirst() {
            return this.first;
        }

        public Multimap<OptionDefinition, Object> getSecond() {
            return this.second;
        }

        private void addDiff(Class<? extends FragmentOptions> fragmentOptionsClass, OptionDefinition option, Object firstValue, Object secondValue) {
            this.differingOptions.put(fragmentOptionsClass, option);
            this.first.put(option, firstValue);
            this.second.put(option, secondValue);
        }

        private void addExtraFirstFragment(Class<? extends FragmentOptions> options) {
            this.extraFirstFragments.add(options);
        }

        private void addExtraSecondFragment(FragmentOptions options) {
            this.extraSecondFragments.add(options);
        }

        private void putStarlarkDiff(Label buildSetting, Object firstValue, Object secondValue) {
            this.starlarkFirst.put(buildSetting, firstValue);
            this.starlarkSecond.put(buildSetting, secondValue);
            this.hasStarlarkOptions = true;
        }

        private void addExtraFirstStarlarkOption(Label buildSetting) {
            this.extraStarlarkOptionsFirst.add(buildSetting);
            this.hasStarlarkOptions = true;
        }

        private void addExtraSecondStarlarkOption(Label buildSetting, Object value) {
            this.extraStarlarkOptionsSecond.put(buildSetting, value);
            this.hasStarlarkOptions = true;
        }

        public Set<Label> getChangedStarlarkOptions() {
            return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.starlarkFirst.keySet())).addAll(this.starlarkSecond.keySet())).addAll(this.extraStarlarkOptionsFirst)).addAll(this.extraStarlarkOptionsSecond.keySet())).build();
        }

        @VisibleForTesting
        Map<Label, Object> getStarlarkFirstForTesting() {
            return this.starlarkFirst;
        }

        @VisibleForTesting
        Map<Label, Object> getStarlarkSecondForTesting() {
            return this.starlarkSecond;
        }

        @VisibleForTesting
        List<Label> getExtraStarlarkOptionsFirstForTesting() {
            return this.extraStarlarkOptionsFirst;
        }

        @VisibleForTesting
        Map<Label, Object> getExtraStarlarkOptionsSecondForTesting() {
            return this.extraStarlarkOptionsSecond;
        }

        boolean areSame() {
            return this.first.isEmpty() && this.second.isEmpty() && this.extraSecondFragments.isEmpty() && this.extraFirstFragments.isEmpty() && this.differingOptions.isEmpty() && this.starlarkFirst.isEmpty() && this.starlarkSecond.isEmpty() && this.extraStarlarkOptionsFirst.isEmpty() && this.extraStarlarkOptionsSecond.isEmpty();
        }

        public String prettyPrint() {
            StringBuilder toReturn = new StringBuilder();
            for (String diff : this.getPrettyPrintList()) {
                toReturn.append(diff).append(System.lineSeparator());
            }
            return toReturn.toString();
        }

        public List<String> getPrettyPrintList() {
            ArrayList<String> toReturn = new ArrayList<String>();
            this.first.forEach((option, value) -> toReturn.add(option.getOptionName() + ":" + value + " -> " + this.second.get((OptionDefinition)option)));
            this.starlarkFirst.forEach((option, value) -> toReturn.add(option + ":" + value + this.starlarkSecond.get(option)));
            return toReturn;
        }
    }

    public static class Builder {
        private final Map<Class<? extends FragmentOptions>, FragmentOptions> fragmentOptions = new HashMap<Class<? extends FragmentOptions>, FragmentOptions>();
        private final Map<Label, Object> starlarkOptions = new HashMap<Label, Object>();

        @CanIgnoreReturnValue
        public Builder merge(BuildOptions options) {
            for (FragmentOptions fragment : options.getNativeOptions()) {
                this.addFragmentOptions(fragment);
            }
            this.addStarlarkOptions(options.getStarlarkOptions());
            return this;
        }

        @CanIgnoreReturnValue
        public <T extends FragmentOptions> Builder addFragmentOptions(T options) {
            this.fragmentOptions.put(options.getClass(), options.getNormalized());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStarlarkOptions(Map<Label, Object> options) {
            this.starlarkOptions.putAll(options);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStarlarkOption(Label key, Object value) {
            this.starlarkOptions.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeFragmentOptions(Class<? extends FragmentOptions> key) {
            this.fragmentOptions.remove(key);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeStarlarkOption(Label key) {
            this.starlarkOptions.remove(key);
            return this;
        }

        public BuildOptions build() {
            return new BuildOptions(ImmutableSortedMap.copyOf(this.fragmentOptions, LEXICAL_FRAGMENT_OPTIONS_COMPARATOR), ImmutableSortedMap.copyOf(this.starlarkOptions));
        }

        private Builder() {
        }
    }
}

