/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.analysis.config.FragmentOptions;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionMetadataTag;
import com.google.devtools.common.options.OptionsParser;
import java.util.Map;
import javax.annotation.Nullable;

public final class BuildOptionDetails {
    private final ImmutableMap<String, OptionDetails> nativeOptionsMap;
    private final ImmutableMap<Label, Object> starlarkOptionsMap;

    @VisibleForTesting
    static BuildOptionDetails forOptionsForTesting(Iterable<? extends FragmentOptions> buildOptions) {
        return BuildOptionDetails.forOptions(buildOptions, ImmutableMap.of());
    }

    static BuildOptionDetails forOptions(Iterable<? extends FragmentOptions> buildOptions, Map<Label, Object> starlarkOptions) {
        ImmutableMap.Builder<String, OptionDetails> map = ImmutableMap.builder();
        try {
            for (FragmentOptions fragmentOptions : buildOptions) {
                ImmutableList<OptionDefinition> optionDefinitions = OptionsParser.getOptionDefinitions(fragmentOptions.getClass());
                Map<OptionDefinition, FragmentOptions.SelectRestriction> selectRestrictions = fragmentOptions.getSelectRestrictions();
                for (OptionDefinition optionDefinition : optionDefinitions) {
                    if (ImmutableList.copyOf(optionDefinition.getOptionMetadataTags()).contains((Object)OptionMetadataTag.INTERNAL)) continue;
                    Object value = optionDefinition.getField().get(fragmentOptions);
                    if (value == null && !optionDefinition.isSpecialNullDefault()) {
                        value = optionDefinition.getUnparsedDefaultValue();
                    }
                    map.put(optionDefinition.getOptionName(), new OptionDetails(fragmentOptions.getClass(), value, optionDefinition.allowsMultiple(), selectRestrictions.get(optionDefinition)));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected illegal access trying to create this configuration's options map: ", e);
        }
        return new BuildOptionDetails(map.buildOrThrow(), ImmutableMap.copyOf(starlarkOptions));
    }

    private BuildOptionDetails(ImmutableMap<String, OptionDetails> nativeOptionsMap, ImmutableMap<Label, Object> starlarkOptionsMap) {
        this.nativeOptionsMap = nativeOptionsMap;
        this.starlarkOptionsMap = starlarkOptionsMap;
    }

    @Nullable
    public Class<? extends FragmentOptions> getOptionClass(String optionName) {
        OptionDetails optionDetails = this.nativeOptionsMap.get(optionName);
        return optionDetails == null ? null : optionDetails.optionsClass;
    }

    @Nullable
    public Object getOptionValue(String optionName) {
        OptionDetails optionDetails = this.nativeOptionsMap.get(optionName);
        return optionDetails == null ? null : optionDetails.value;
    }

    @Nullable
    public Object getOptionValue(Label optionName) {
        return this.starlarkOptionsMap.get(optionName);
    }

    public boolean allowsMultipleValues(String optionName) {
        OptionDetails optionDetails = this.nativeOptionsMap.get(optionName);
        return optionDetails != null && optionDetails.allowsMultiple;
    }

    @Nullable
    public FragmentOptions.SelectRestriction getSelectRestriction(String optionName) {
        OptionDetails optionDetails = this.nativeOptionsMap.get(optionName);
        return optionDetails == null ? null : optionDetails.selectRestriction;
    }

    private static final class OptionDetails {
        private final Class<? extends FragmentOptions> optionsClass;
        @Nullable
        private final Object value;
        private final boolean allowsMultiple;
        @Nullable
        private final FragmentOptions.SelectRestriction selectRestriction;

        private OptionDetails(Class<? extends FragmentOptions> optionsClass, Object value, boolean allowsMultiple, @Nullable FragmentOptions.SelectRestriction selectRestriction) {
            this.optionsClass = optionsClass;
            this.value = value;
            this.allowsMultiple = allowsMultiple;
            this.selectRestriction = selectRestriction;
        }
    }
}

