/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.devtools.build.lib.analysis.AutoValue_RequiredConfigFragmentsProvider;
import com.google.devtools.build.lib.analysis.TransitiveInfoProvider;
import com.google.devtools.build.lib.analysis.config.Fragment;
import com.google.devtools.build.lib.analysis.config.FragmentOptions;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.lib.util.ClassName;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@AutoValue
public abstract class RequiredConfigFragmentsProvider
implements TransitiveInfoProvider {
    private static final Interner<RequiredConfigFragmentsProvider> interner = BlazeInterners.newWeakInterner();
    @SerializationConstant
    public static final RequiredConfigFragmentsProvider EMPTY = new AutoValue_RequiredConfigFragmentsProvider(ImmutableSet.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableSet.of());

    RequiredConfigFragmentsProvider() {
    }

    public abstract ImmutableSet<Class<? extends FragmentOptions>> getOptionsClasses();

    public abstract ImmutableSet<Class<? extends Fragment>> getFragmentClasses();

    public abstract ImmutableSet<String> getDefines();

    public abstract ImmutableSet<Label> getStarlarkOptions();

    public final String toString() {
        return MoreObjects.toStringHelper(RequiredConfigFragmentsProvider.class).add("optionsClasses", Collections2.transform(this.getOptionsClasses(), ClassName::getSimpleNameWithOuter)).add("fragmentClasses", Collections2.transform(this.getFragmentClasses(), ClassName::getSimpleNameWithOuter)).add("defines", this.getDefines()).add("starlarkOptions", this.getStarlarkOptions()).toString();
    }

    public static RequiredConfigFragmentsProvider merge(List<RequiredConfigFragmentsProvider> providers) {
        Preconditions.checkArgument(!providers.isEmpty());
        Builder merged = null;
        RequiredConfigFragmentsProvider candidate = EMPTY;
        for (RequiredConfigFragmentsProvider provider : providers) {
            if (provider == EMPTY) continue;
            if (merged != null) {
                merged.merge(provider);
                continue;
            }
            if (candidate == EMPTY) {
                candidate = provider;
                continue;
            }
            merged = RequiredConfigFragmentsProvider.builder().merge(candidate).merge(provider);
        }
        return merged == null ? candidate : merged.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Set<Class<? extends FragmentOptions>> optionsClasses = ImmutableSet.of();
        private Set<Class<? extends Fragment>> fragmentClasses = ImmutableSet.of();
        private Set<String> defines = ImmutableSet.of();
        private Set<Label> starlarkOptions = ImmutableSet.of();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder addOptionsClass(Class<? extends FragmentOptions> optionsClass) {
            this.optionsClasses = Builder.append(this.optionsClasses, optionsClass);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addOptionsClasses(Collection<Class<? extends FragmentOptions>> optionsClasses) {
            this.optionsClasses = Builder.appendAll(this.optionsClasses, optionsClasses);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFragmentClasses(Collection<Class<? extends Fragment>> fragmentClasses) {
            this.fragmentClasses = Builder.appendAll(this.fragmentClasses, fragmentClasses);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addDefine(String define) {
            this.defines = Builder.append(this.defines, define);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addDefines(Collection<String> defines) {
            this.defines = Builder.appendAll(this.defines, defines);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStarlarkOption(Label starlarkOption) {
            this.starlarkOptions = Builder.append(this.starlarkOptions, starlarkOption);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStarlarkOptions(Collection<Label> starlarkOptions) {
            this.starlarkOptions = Builder.appendAll(this.starlarkOptions, starlarkOptions);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder merge(RequiredConfigFragmentsProvider provider) {
            this.optionsClasses = Builder.appendAll(this.optionsClasses, provider.getOptionsClasses());
            this.fragmentClasses = Builder.appendAll(this.fragmentClasses, provider.getFragmentClasses());
            this.defines = Builder.appendAll(this.defines, provider.getDefines());
            this.starlarkOptions = Builder.appendAll(this.starlarkOptions, provider.getStarlarkOptions());
            return this;
        }

        private static <T> Set<T> append(Set<T> set, T t2) {
            if (set instanceof ImmutableSet) {
                if (set.contains(t2)) {
                    return set;
                }
                set = new HashSet<T>(set);
            }
            set.add(t2);
            return set;
        }

        private static <T> Set<T> appendAll(Set<T> set, Collection<T> ts) {
            if (ts instanceof Set) {
                return Builder.appendAll(set, (Set)ts);
            }
            if (set instanceof ImmutableSet) {
                if (set.containsAll(ts)) {
                    return set;
                }
                set = new HashSet<T>(set);
            }
            set.addAll(ts);
            return set;
        }

        private static <T> Set<T> appendAll(Set<T> set, Set<T> ts) {
            if (set.size() > ts.size()) {
                if (set instanceof ImmutableSet && set.containsAll(ts)) {
                    return set;
                }
            } else if (ts.size() > set.size()) {
                if (ts instanceof ImmutableSet && ts.containsAll(set)) {
                    return ts;
                }
            } else if (set instanceof ImmutableSet) {
                if (set.equals(ts)) {
                    return set;
                }
            } else if (ts instanceof ImmutableSet && ts.equals(set)) {
                return ts;
            }
            if (set instanceof ImmutableSet) {
                set = new HashSet<T>(set);
            }
            set.addAll(ts);
            return set;
        }

        public RequiredConfigFragmentsProvider build() {
            if (this.optionsClasses.isEmpty() && this.fragmentClasses.isEmpty() && this.defines.isEmpty() && this.starlarkOptions.isEmpty()) {
                return EMPTY;
            }
            return interner.intern(new AutoValue_RequiredConfigFragmentsProvider(ImmutableSet.copyOf(this.optionsClasses), ImmutableSet.copyOf(this.fragmentClasses), ImmutableSet.copyOf(this.defines), ImmutableSet.copyOf(this.starlarkOptions)));
        }
    }
}

