/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.analysis.config.CoreOptionConverters;
import com.google.devtools.build.lib.analysis.config.FragmentOptions;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.util.OptionsUtils;
import com.google.devtools.build.lib.util.RegexFilter;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.common.options.Converters;
import com.google.devtools.common.options.Option;
import com.google.devtools.common.options.OptionDocumentationCategory;
import com.google.devtools.common.options.OptionEffectTag;
import com.google.devtools.common.options.OptionMetadataTag;
import java.util.List;
import java.util.Map;

public class PlatformOptions
extends FragmentOptions {
    public static final PathFragment DEFAULT_PLATFORM_MAPPINGS = PathFragment.create("platform_mappings");
    private static final ImmutableSet<String> DEFAULT_PLATFORM_NAMES = ImmutableSet.of("host", "host_platform", "target_platform", "default_host", "default_target");
    @Option(name="host_platform", oldName="experimental_host_platform", converter=CoreOptionConverters.EmptyToNullLabelConverter.class, defaultValue="@local_config_platform//:host", documentationCategory=OptionDocumentationCategory.TOOLCHAIN, effectTags={OptionEffectTag.AFFECTS_OUTPUTS, OptionEffectTag.CHANGES_INPUTS, OptionEffectTag.LOADING_AND_ANALYSIS}, help="The label of a platform rule that describes the host system.")
    public Label hostPlatform;
    @Option(name="extra_execution_platforms", converter=Converters.CommaSeparatedOptionListConverter.class, defaultValue="", documentationCategory=OptionDocumentationCategory.TOOLCHAIN, effectTags={OptionEffectTag.EXECUTION}, help="The platforms that are available as execution platforms to run actions. Platforms can be specified by exact target, or as a target pattern. These platforms will be considered before those declared in the WORKSPACE file by register_execution_platforms(). This option may only be set once; later instances will override earlier flag settings.")
    public List<String> extraExecutionPlatforms;
    @Option(name="platforms", oldName="experimental_platforms", converter=CoreOptionConverters.LabelListConverter.class, defaultValue="", documentationCategory=OptionDocumentationCategory.TOOLCHAIN, effectTags={OptionEffectTag.AFFECTS_OUTPUTS, OptionEffectTag.CHANGES_INPUTS, OptionEffectTag.LOADING_AND_ANALYSIS}, help="The labels of the platform rules describing the target platforms for the current command.")
    public List<Label> platforms;
    @Option(name="extra_toolchains", defaultValue="null", converter=Converters.CommaSeparatedOptionListConverter.class, documentationCategory=OptionDocumentationCategory.TOOLCHAIN, allowMultiple=true, effectTags={OptionEffectTag.AFFECTS_OUTPUTS, OptionEffectTag.CHANGES_INPUTS, OptionEffectTag.LOADING_AND_ANALYSIS}, help="The toolchain rules to be considered during toolchain resolution. Toolchains can be specified by exact target, or as a target pattern. These toolchains will be considered before those declared in the WORKSPACE file by register_toolchains().")
    public List<String> extraToolchains;
    @Option(name="toolchain_resolution_override", allowMultiple=true, defaultValue="null", documentationCategory=OptionDocumentationCategory.UNDOCUMENTED, effectTags={OptionEffectTag.AFFECTS_OUTPUTS, OptionEffectTag.CHANGES_INPUTS, OptionEffectTag.LOADING_AND_ANALYSIS}, deprecationWarning="toolchain_resolution_override is now a no-op and will be removed in an upcoming release", help="Override toolchain resolution for a toolchain type with a specific toolchain. Example: --toolchain_resolution_override=@io_bazel_rules_go//:toolchain=@io_bazel_rules_go//:linux-arm64-toolchain")
    public List<String> toolchainResolutionOverrides;
    @Option(name="toolchain_resolution_debug", defaultValue="-.*", converter=RegexFilter.RegexFilterConverter.class, documentationCategory=OptionDocumentationCategory.LOGGING, effectTags={OptionEffectTag.TERMINAL_OUTPUT}, help="Print debug information during toolchain resolution. The flag takes a regex, which is checked against toolchain types and specific targets to see which to debug. Multiple regexes may be  separated by commas, and then each regex is checked separately. Note: The output of this flag is very complex and will likely only be useful to experts in toolchain resolution.")
    public RegexFilter toolchainResolutionDebug;
    @Option(name="incompatible_use_toolchain_resolution_for_java_rules", defaultValue="true", documentationCategory=OptionDocumentationCategory.UNDOCUMENTED, effectTags={OptionEffectTag.UNKNOWN}, metadataTags={OptionMetadataTag.INCOMPATIBLE_CHANGE}, help="No-op. Kept here for backwards compatibility.")
    public boolean useToolchainResolutionForJavaRules;
    @Option(name="platform_mappings", converter=OptionsUtils.EmptyToNullRelativePathFragmentConverter.class, defaultValue="", documentationCategory=OptionDocumentationCategory.TOOLCHAIN, effectTags={OptionEffectTag.AFFECTS_OUTPUTS, OptionEffectTag.CHANGES_INPUTS, OptionEffectTag.LOADING_AND_ANALYSIS}, help="The location of a mapping file that describes which platform to use if none is set or which flags to set when a platform already exists. Must be relative to the main workspace root. Defaults to 'platform_mappings' (a file directly under the workspace root).")
    public PathFragment platformMappings;
    @Option(name="experimental_add_exec_constraints_to_targets", converter=RegexFilterToLabelListConverter.class, defaultValue="null", documentationCategory=OptionDocumentationCategory.TOOLCHAIN, effectTags={OptionEffectTag.LOADING_AND_ANALYSIS}, allowMultiple=true, help="List of comma-separated regular expressions, each optionally prefixed by - (negative expression), assigned (=) to a list of comma-separated constraint value targets. If a target matches no negative expression and at least one positive expression its toolchain resolution will be performed as if it had declared the constraint values as execution constraints. Example: //demo,-test=@platforms//cpus:x86_64 will add 'x86_64' to any target under //demo except for those whose name contains 'test'.")
    public List<Map.Entry<RegexFilter, List<Label>>> targetFilterToAdditionalExecConstraints;

    public static boolean platformIsDefault(Label platform) {
        return DEFAULT_PLATFORM_NAMES.contains(platform.getName());
    }

    @Override
    public PlatformOptions getExec() {
        PlatformOptions exec = (PlatformOptions)this.getDefault();
        exec.platforms = this.hostPlatform == null ? ImmutableList.of() : ImmutableList.of(this.hostPlatform);
        exec.hostPlatform = this.hostPlatform;
        exec.platformMappings = this.platformMappings;
        exec.extraExecutionPlatforms = this.extraExecutionPlatforms;
        exec.extraToolchains = this.extraToolchains;
        exec.toolchainResolutionDebug = this.toolchainResolutionDebug;
        exec.toolchainResolutionOverrides = this.toolchainResolutionOverrides;
        exec.useToolchainResolutionForJavaRules = this.useToolchainResolutionForJavaRules;
        return exec;
    }

    @Override
    public PlatformOptions getNormalized() {
        PlatformOptions result = (PlatformOptions)this.clone();
        result.extraToolchains = PlatformOptions.dedupeOnly(result.extraToolchains);
        if (result.platforms.size() > 1) {
            result.platforms = ImmutableList.of(result.platforms.get(0));
        }
        return result;
    }

    public Label computeTargetPlatform() {
        if (!this.platforms.isEmpty()) {
            return Iterables.getFirst(this.platforms, null);
        }
        return this.hostPlatform;
    }

    public static final class RegexFilterToLabelListConverter
    extends Converters.AssignmentToListOfValuesConverter<RegexFilter, Label> {
        public RegexFilterToLabelListConverter() {
            super(new RegexFilter.RegexFilterConverter(), new CoreOptionConverters.LabelConverter(), Converters.AssignmentToListOfValuesConverter.AllowEmptyKeys.NO);
        }

        @Override
        public String getTypeDescription() {
            return "a '<RegexFilter>=<label1>[,<label2>,...]' assignment";
        }
    }
}

