/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BlazeVersionInfo {
    public static final String BUILD_LABEL = "Build label";
    public static final String BUILD_TIMESTAMP = "Build timestamp as int";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static BlazeVersionInfo instance = null;
    private final Map<String, String> buildData = Maps.newTreeMap();

    public BlazeVersionInfo(Map<String, String> info) {
        this.buildData.putAll(info);
    }

    public static synchronized BlazeVersionInfo instance() {
        if (instance == null) {
            return new BlazeVersionInfo(ImmutableMap.of());
        }
        return instance;
    }

    private static void logVersionInfo(BlazeVersionInfo info) {
        if (info.getSummary() == null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Bazel release version information not available");
        } else {
            ((GoogleLogger.Api)logger.atInfo()).log("Bazel version info: %s", info.getSummary());
        }
    }

    public static synchronized void setBuildInfo(Map<String, String> info) {
        if (instance != null) {
            throw new IllegalStateException("setBuildInfo called twice.");
        }
        instance = new BlazeVersionInfo(info);
        BlazeVersionInfo.logVersionInfo(instance);
    }

    public boolean isAvailable() {
        return !this.buildData.isEmpty();
    }

    @Nullable
    public String getSummary() {
        if (this.buildData.isEmpty()) {
            return null;
        }
        return this.buildData.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining("\n"));
    }

    public boolean isReleasedBlaze() {
        String buildLabel = this.buildData.get(BUILD_LABEL);
        return buildLabel != null && buildLabel.length() > 0;
    }

    public String getReleaseName() {
        String buildLabel = this.buildData.get(BUILD_LABEL);
        return buildLabel != null && buildLabel.length() > 0 ? "release " + buildLabel : "development version";
    }

    public String getVersion() {
        String buildLabel = this.buildData.get(BUILD_LABEL);
        return buildLabel != null ? buildLabel : "";
    }

    public long getTimestamp() {
        String timestamp = this.buildData.get(BUILD_TIMESTAMP);
        if (timestamp == null || timestamp.equals("0")) {
            return new Date().getTime();
        }
        return Long.parseLong(timestamp);
    }

    @VisibleForTesting
    public Map<String, String> getBuildData() {
        return this.buildData;
    }
}

