/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.devtools.build.lib.bugreport.BugReport;
import com.google.devtools.build.lib.io.InconsistentFilesystemException;
import com.google.devtools.build.lib.packages.BuildFileNotFoundException;
import com.google.devtools.build.lib.server.FailureDetails;
import com.google.devtools.build.lib.util.DetailedExitCode;
import com.google.devtools.build.lib.vfs.PathFragment;
import com.google.devtools.build.lib.vfs.Root;
import java.util.Map;
import javax.annotation.Nullable;

public interface PackageRootResolver {
    @Nullable
    public Map<PathFragment, Root> findPackageRootsForFiles(Iterable<PathFragment> var1) throws PackageRootException, InterruptedException;

    public static class PackageRootException
    extends Exception {
        private final FailureDetails.IncludeScanning error;

        private PackageRootException(PathFragment execPath, FailureDetails.IncludeScanning error, Exception e) {
            super("Unable to resolve " + execPath.getPathString() + " as an artifact: " + e.getMessage(), e);
            this.error = error;
        }

        public static PackageRootException create(PathFragment execPath, BuildFileNotFoundException e) {
            FailureDetails.FailureDetail failureDetail = e.getDetailedExitCode().getFailureDetail();
            FailureDetails.IncludeScanning.Code code = e.hasExplicitDetailedExitCode() ? (DetailedExitCode.getExitCode(failureDetail).isInfrastructureFailure() ? FailureDetails.IncludeScanning.Code.SYSTEM_PACKAGE_LOAD_FAILURE : FailureDetails.IncludeScanning.Code.USER_PACKAGE_LOAD_FAILURE) : FailureDetails.IncludeScanning.Code.UNDIFFERENTIATED_PACKAGE_LOAD_FAILURE;
            FailureDetails.PackageLoading.Code packageLoadingCode = failureDetail.getPackageLoading().getCode();
            if (packageLoadingCode == FailureDetails.PackageLoading.Code.PACKAGE_LOADING_UNKNOWN) {
                BugReport.sendBugReport(new IllegalStateException("Exception for " + execPath + " had no PackageLoading.Code: " + failureDetail, e));
            }
            return new PackageRootException(execPath, FailureDetails.IncludeScanning.newBuilder().setCode(code).setPackageLoadingCode(packageLoadingCode).build(), e);
        }

        public static PackageRootException create(PathFragment execPath, InconsistentFilesystemException e) {
            return new PackageRootException(execPath, FailureDetails.IncludeScanning.newBuilder().setCode(FailureDetails.IncludeScanning.Code.SYSTEM_PACKAGE_LOAD_FAILURE).setPackageLoadingCode(FailureDetails.PackageLoading.Code.PERSISTENT_INCONSISTENT_FILESYSTEM_ERROR).build(), e);
        }

        public FailureDetails.IncludeScanning getError() {
            return this.error;
        }
    }
}

