/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.actions;

import com.google.protobuf.ByteString;
import java.io.Serializable;

@FunctionalInterface
public interface HasDigest
extends Serializable {
    public static final HasDigest EMPTY = new ByteStringDigest(new byte[0]);

    public byte[] getDigest();

    public static final class ByteStringDigest
    implements HasDigest {
        private final ByteString bytes;

        public ByteStringDigest(byte[] bytes) {
            this.bytes = ByteString.copyFrom(bytes);
        }

        @Override
        public byte[] getDigest() {
            return this.bytes.toByteArray();
        }

        public boolean equals(Object other) {
            if (other instanceof ByteStringDigest) {
                return this.bytes.equals(((ByteStringDigest)other).bytes);
            }
            return false;
        }

        public int hashCode() {
            return this.bytes.hashCode();
        }
    }
}

